/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
  Archivo: sw/storage.js — Rol: Helpers de chrome.storage (get/set/remove) y claves varias.
  Descripcion de todo el proyecto: 
       MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI 
          (login JWT, export/import, backups/renovaciones).  
  Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función.
  En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa liena de rol  
*/

export async function stGet(keys) {
  return await new Promise((resolve, reject) => {
    try {
      chrome.storage.local.get(keys, (res) => {
        if (chrome.runtime.lastError) return reject(chrome.runtime.lastError);
        resolve(res || {});
      });
    } catch (e) { reject(e); }
  });
}

export async function stSet(obj) {
  return await new Promise((resolve, reject) => {
    try {
      chrome.storage.local.set(obj, () => {
        if (chrome.runtime.lastError) return reject(chrome.runtime.lastError);
        resolve();
      });
    } catch (e) { reject(e); }
  });
}

export async function stRemove(keys) {
  return await new Promise((resolve, reject) => {
    try {
      chrome.storage.local.remove(keys, () => {
        if (chrome.runtime.lastError) return reject(chrome.runtime.lastError);
        resolve();
      });
    } catch (e) { reject(e); }
  });
}

export const ACTIVE_RUN_KEY = 'walla.active_run_id';
