/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
  Archivo: sw/outbox.js — Rol: Cola de reintentos para /listings/mark (idempotente).
  Descripcion de todo el proyecto: 
       MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI 
          (login JWT, export/import, backups/renovaciones).  
  Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función.
  En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa liena de rol  
*/

import { stGet, stSet } from './storage.js';
import { apiFetch, withDeviceHeaders } from './api_client.js';

const OUTBOX_KEY = 'ml.outbox';
let OUTBOX_LOCK = false;

export async function outboxGet() {
  const s = await stGet([OUTBOX_KEY]);
  const arr = s[OUTBOX_KEY];
  return Array.isArray(arr) ? arr : [];
}
export async function outboxSet(list) { await stSet({ [OUTBOX_KEY]: list }); }
export async function outboxPushMark(payload) {
  try {
    const list = await outboxGet();
    list.push({ ts: Date.now(), kind: 'mark', payload });
    await outboxSet(list);
  } catch (e) { /* outbox push failed */ }
}

export async function outboxDrainOnce() {
  if (OUTBOX_LOCK) return;
  OUTBOX_LOCK = true;
  try {
    const list = await outboxGet();
    if (!list.length) return;
    const keep = [];
    for (const entry of list) {
      if (entry.kind !== 'mark' || !entry.payload) continue;
      try {
        const headers = withDeviceHeaders({ 'Content-Type':'application/json' });
        const r = await apiFetch('/api/walla/listings/mark', { method:'POST', headers, body: JSON.stringify(entry.payload) });
        if (!r.ok) keep.push(entry);
      } catch {
        keep.push(entry);
      }
    }
    await outboxSet(keep);
  } finally {
    OUTBOX_LOCK = false;
  }
}

export function startOutboxDrainInterval() {
  setInterval(() => { outboxDrainOnce().catch(err => { console.error(`[${filepath.split('/').pop()}] Error:`, err); }); }, 15000);
}
