/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
  Archivo: sw/bus.js — Rol: Comunicación con tabs/panel: safeSend, broadcastAllTabs, sendToTab.
  Descripcion de todo el proyecto: 
       MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI 
          (login JWT, export/import, backups/renovaciones).  
  Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función.
  En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa liena de rol  
*/

export function safeSend(message) {
  try { chrome.runtime.sendMessage(message, () => void chrome.runtime.lastError); }
  catch { /* noop */ }
}

export async function broadcastAllTabs(message) {
  try {
    const tabs = await chrome.tabs.query({ url: ['https://*.wallapop.com/*', 'https://*.wallapop.es/*'] });
    for (const t of tabs) {
      if (!t.id) continue;
      const maybe = chrome.tabs.sendMessage(t.id, message);
      if (maybe && typeof maybe.then === 'function') maybe.catch?.(()=>{});
    }
  } catch {}
}

const ML_LOG = true;
export async function sendToTab(tabId, msg) {
  return await new Promise((resolve) => {
    try {
      chrome.tabs.sendMessage(tabId, msg, (reply) => {
        const le = chrome.runtime.lastError ? chrome.runtime.lastError.message : null;
        if (ML_LOG) {
        }
        resolve(reply || { ok:false, code: le ? 'lastError' : 'no_reply', error: le || 'no_reply' });
      });
    } catch (e) {
      if (ML_LOG) console.error('[SW] sendToTab threw', e);
      resolve({ ok:false, code:'exception', error:String(e?.message || e) });
    }
  });
}
