/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/version-tracker.js — Rol: Actualizar versión de extensión en backend
    Descripcion de todo el proyecto: 
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI 
            (login JWT, export/import, backups/renovaciones).  
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función, solo cambiarlos si se modifica la funcion.
    En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa linea de rol 
*/

import { logger } from './logger.js';

/**
 * Envía mensaje al Service Worker
 */
function sw(msg) {
  return new Promise(resolve => {
    chrome.runtime.sendMessage(msg, response => {
      resolve(response);
    });
  });
}

/**
 * Actualiza la versión de la extensión en el backend (silencioso)
 * ✅ v10.5.81: Reescrito para usar SW según Regla #36
 */
export async function updateExtensionVersion() {
  try {
    const version = chrome.runtime.getManifest().version;
    
    console.log('[VERSION] Enviando PATCH con version:', version);
    
    const response = await sw({
      type: 'API.FETCH_JSON',
      url: '/api/user/preferences',
      method: 'PATCH',
      body: {
        extension_version: version
      }
    });

    console.log('[VERSION] Respuesta completa:', JSON.stringify(response));

    if (response?.ok) {
      logger.debug(`[VERSION] ✅ Versión ${version} registrada en backend`);
    } else {
      logger.warn(`[VERSION] ⚠️ No se pudo registrar versión: ${response?.error}`);
    }
  } catch (error) {
    // Silencioso - no mostrar error al usuario
    console.error('[VERSION] Error:', error);
    logger.warn(`[VERSION] ⚠️ Error registrando versión: ${error?.message}`);
  }
}
