/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/success-modal.js – Rol: Modal de éxito al completar publicaciones
    Descripcion de todo el proyecto:
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI
            (login JWT, export/import, backups/renovaciones).
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función.
    
    ✅ v10.5.32: Refactorizado para usar base-modal.js
*/

import { createModal, closeModal, getModalOverlay } from './base-modal.js';

const MODAL_ID = 'success-modal-overlay';

/**
 * Mostrar modal de éxito cuando terminan las publicaciones
 * @param {Object} stats - Estadísticas de la publicación
 * @param {number} stats.total - Total de anuncios procesados
 * @param {number} stats.published - Anuncios publicados con éxito
 * @param {number} stats.errors - Anuncios con error
 */
export function showSuccessModal({ total, published, errors }) {
  // ✅ v10.5.23: Solo mostrar modal si 100% éxito (al menos 1 publicado Y 0 errores)
  if (published === 0 || errors > 0) {
    return; // No mostrar modal
  }
  
  // Calcular tasa de éxito
  const successRate = total > 0 ? Math.round((published / total) * 100) : 0;
  
  // HTML del modal
  const content = `
    <div class="success-modal">
      <div class="success-icon">🎉</div>
      <h2 class="success-title">¡Felicidades!</h2>
      <p class="success-message">
        Has completado el proceso de publicación con éxito
      </p>
      
      <div class="success-stats">
        <div class="success-stat">
          <div class="success-stat-value">${total}</div>
          <div class="success-stat-label">Total</div>
        </div>
        <div class="success-stat">
          <div class="success-stat-value">${published}</div>
          <div class="success-stat-label">Publicados</div>
        </div>
        <div class="success-stat">
          <div class="success-stat-value">${successRate}%</div>
          <div class="success-stat-label">Éxito</div>
        </div>
      </div>
      
      <button class="success-button">Aceptar</button>
    </div>
  `;
  
  // Crear modal usando base-modal
  createModal({
    id: MODAL_ID,
    overlayClass: 'success-modal-overlay',
    content,
    closeOnOverlayClick: true,
    closeOnEsc: true,
    autoCloseMs: 10000, // Auto-cerrar después de 10 segundos
    onOpen: (overlay) => {
      // Añadir confetti
      addConfetti(overlay);
      
      // Configurar botón de cerrar
      const btn = overlay.querySelector('.success-button');
      if (btn) {
        btn.addEventListener('click', () => closeModal(MODAL_ID));
      }
    }
  });
}

/**
 * Añadir efecto confetti al modal
 */
function addConfetti(container) {
  const colors = ['#10b981', '#3b82f6', '#f59e0b', '#ef4444', '#8b5cf6'];
  const confettiCount = 50;
  
  for (let i = 0; i < confettiCount; i++) {
    const confetti = document.createElement('div');
    confetti.className = 'confetti';
    confetti.style.left = Math.random() * 100 + '%';
    confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
    confetti.style.animationDelay = Math.random() * 3 + 's';
    confetti.style.animationDuration = (Math.random() * 2 + 3) + 's';
    container.appendChild(confetti);
  }
}

/**
 * Cerrar modal manualmente
 */
export function closeSuccessModal() {
  closeModal(MODAL_ID);
}
