/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/state.js – Rol: Estado global UI (AUTH, RUN_ACTIVE, flags, refs DOM) + UIState centralizado
    Descripcion de todo el proyecto:
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI
            (login JWT, export/import, backups/renovaciones).
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función, solo cambiarlos si se modifica la funcion.
    En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa linea de rol
*/

// ===== Refs DOM (coinciden con panel.html) =====
export const verEl      = document.getElementById('ml-ver');
export const pillIP     = document.getElementById('pill-ip');
export const pillUser   = document.getElementById('pill-user');

export const blockLogin = document.getElementById('block-login');
export const blockApp   = document.getElementById('block-app');

export const userEmail  = document.getElementById('user-email');
export const inEmail    = document.getElementById('in-email');
export const inPass     = document.getElementById('in-pass');
export const remember   = document.getElementById('remember');
export const listEmails = document.getElementById('email-suggest');

export const btnLogin   = document.getElementById('btn-login');
export const btnGoogle  = document.getElementById('btn-google');
export const btnBackup  = document.getElementById('btn-backup');
// ✅ v4.97.0: Botones de publicación gestionados por ButtonManager
// export const btnPublish = document.getElementById('btn-publish');

// Run box eliminado

// ✅ v4.97.0: Botones de publicación gestionados por ButtonManager
// export const btnResumePublish = document.getElementById('btn-publish-all');
export const warningBadges    = document.getElementById('warningBadges');

export const btnMenu   = document.getElementById('btn-menu');
export const menuPop   = document.getElementById('menu-popover');
export const miConfig  = document.getElementById('mi-config');
export const miLogout  = document.getElementById('mi-logout');
export const btnPopout = document.getElementById('btn-popout-config');
export const btnPopoutTab = document.getElementById('btn-popout-tab'); // ✅ v10.5.144

export const selAccount = document.getElementById('sel-account');
export const accBadge   = document.getElementById('acc-logged-badge');
export const accTxt     = accBadge?.querySelector?.('.txt') || null;
export const avatarEl   = document.getElementById('acc-avatar');

export const LEGAL = {
  overlay:      document.getElementById('ml-legal-overlay'),
  frame:        document.getElementById('ml-legal-frame'),
  title:        document.getElementById('ml-legal-title'),
  backBtn:      document.getElementById('ml-legal-back'),
  closeBtn:     document.getElementById('ml-legal-close'),
  cookieBanner: document.getElementById('ml-cookie-banner'),
  cookieAccept: document.getElementById('ml-cookie-accept'),
};

// ===== Estado compartido (mutables) =====
export let AUTH = { state: 'UNAUTHENTICATED', on: false, user: null, config: { API_BASE: '' } };
export let RUN_ACTIVE = false;
export let currentRunId = null;
export let lastNotifiedTerminal = null;
export let lastWarnedRunId = null;
export let LAST_PENDING_RUN_ID = null;

// ✅ Estado centralizado del backup (fuente única de verdad)
export let BACKUP_STATE = {
  status: 'idle',        // idle | running | incomplete | ok | error
  pending: 0,
  errors: 0,
  seen: 0,
  total: 0,
  run_id: null,
  viewed_at: null        // Timestamp cuando se marcó como visto (sincronización multi-dispositivo)
};

// Usados por ui.js
export let pollTimer = null;
export let LAST_GOOD = { alias: '', avatar: '' };
export let NOLOGIN_HOLD = null;
export const NOLOGIN_HOLD_MS = 5000;
export let _POST_BK_PROMPTED_RUN_ID = null;
export let API_STATE = 'checking';

// ===== Timers internos (SSE/polling) =====
export let pollingIntervalId = null;
export let _es = null;
export let _sseRetryTimer = null;
export let _hbTimer = null;

// ===== Constantes de chequeo API =====
export const CHECK_INTERVAL_MS  = 10000;
export const CHECKING_GRACE_MS  = 5000;
export const OFFLINE_MS         = 60000;
export const RECONNECT_MS       = 120000;

// ===== ✅ NUEVO: Estado UI Centralizado =====
export const UIState = {
  // Cuenta actual
  currentAccountId: null,
  
  // Estado de botón Backup
  backup: {
    status: 'idle',    // 'idle' | 'running' | 'ok' | 'error' | 'cancelled' | 'incomplete' | 'blocked'
    pending: 0,
    errors: 0
  },
  
  // Estado de botón Reanudar Publicación
  publish: {
    show: false,       // Mostrar/ocultar botón
    pending: 0,
    errors: 0,
    run_id: null
  },
  
  // Validation warnings
  validation: {
    duplicates: [],
    orphans: [],
    inconsistent_states: []
  },
  
  // Loading global (para deshabilitar selector)
  loading: false
};

// ===== ✅ Setter centralizado con auto-render =====
let _renderCallback = null;

export function setRenderCallback(fn) {
  _renderCallback = fn;
}

export function setUIState(key, value) {
  if (!(key in UIState)) {
    return;
  }
  
  UIState[key] = value;
  
  // Trigger re-render automático
  if (_renderCallback) {
    _renderCallback();
  }
}

// Helper: actualizar sub-propiedades
export function updateUIState(key, partialValue) {
  if (!(key in UIState)) {
    return;
  }
  
  UIState[key] = { ...UIState[key], ...partialValue };
  
  if (_renderCallback) {
    _renderCallback();
  }
}

// ===== Setters legacy (compatibilidad con código existente) =====
export function set_AUTH(v){ AUTH = v; return AUTH; }
export function set_RUN_ACTIVE(v){ RUN_ACTIVE = v; return RUN_ACTIVE; }
export function set_currentRunId(v){ currentRunId = v; return currentRunId; }
export function set_lastNotifiedTerminal(v){ lastNotifiedTerminal = v; return lastNotifiedTerminal; }
export function set_lastWarnedRunId(v){ lastWarnedRunId = v; return lastWarnedRunId; }

// ✅ Setter para estado del backup (fuente única de verdad)
export function setBackupState(newState) {
  BACKUP_STATE = { ...BACKUP_STATE, ...newState };
  
  
  // 🔄 Trigger actualización UI automática
  import('./ui.js').then(UI => {
    UI.updateBackupButtonUI(BACKUP_STATE);
    // ✅ v4.98.0: updatePublishButtonsState → ButtonManager gestiona automáticamente
    // UI.updatePublishButtonsState(BACKUP_STATE);
  });
  
  return BACKUP_STATE;
}

// ✅ Helper: ¿Hay backup activo?
export function isBackupActive() {
  return BACKUP_STATE.status === 'running';
}

// ✅ Helper: ¿Se puede publicar? (solo si backup OK o idle)
export function canPublish() {
  const status = BACKUP_STATE.status;
  return status === 'ok' || status === 'idle';
}
export function set_LAST_PENDING_RUN_ID(v){ LAST_PENDING_RUN_ID = v; return LAST_PENDING_RUN_ID; }
export function set_pollTimer(v){ pollTimer = v; return pollTimer; }
export function set_LAST_GOOD(v){ LAST_GOOD = v; return LAST_GOOD; }
export function set_NOLOGIN_HOLD(v){ NOLOGIN_HOLD = v; return NOLOGIN_HOLD; }
export function set__POST_BK_PROMPTED_RUN_ID(v){ _POST_BK_PROMPTED_RUN_ID = v; return _POST_BK_PROMPTED_RUN_ID; }
export function set_API_STATE(v){ API_STATE = v; return API_STATE; }
export function set_pollingIntervalId(v){ pollingIntervalId = v; return pollingIntervalId; }
export function set__es(v){ _es = v; return _es; }
export function set__sseRetryTimer(v){ _sseRetryTimer = v; return _sseRetryTimer; }
export function set__hbTimer(v){ _hbTimer = v; return _hbTimer; }

/* =============================================
   ✅ SISTEMA DE ESTADOS DE USUARIO
   ============================================= */
import { USER_STATES } from './constants.js';
import { logger } from './logger.js';

// ✅ Imports eliminados - backend maneja estado de usuario

/**
 * Determina el estado actual del usuario según cuentas y anuncios
 * @param {Array} accounts - Lista de cuentas del usuario
 * @param {Number} listingsCount - Número de anuncios
 * @param {Boolean} isFirstTime - Si es primera vez del usuario
 * @returns {String} Estado del usuario
 */
export async function determineUserState(accounts, listingsCount = 0) {
  // Usuario sin cuentas
  if (!accounts || accounts.length === 0) {
    return USER_STATES.NEW_USER_NO_ACCOUNTS;
  }
  
  // ✅ Simplificado: Backend determina si es usuario nuevo (created_at)
  // Usuario con cuenta pero sin anuncios
  if (listingsCount === 0) {
    return USER_STATES.HAS_ACCOUNTS_NO_LISTINGS;
  }
  
  // Usuario normal (ya tiene anuncios)
  return USER_STATES.HAS_ACCOUNTS_WITH_LISTINGS;
}

/**
 * @deprecated Backend maneja estado de usuario con created_at
 */
export async function markUserAsExperienced() {
}