/**
 * Configuración del módulo de onboarding
 * @module onboarding/config
 * 
 * Centraliza toda la configuración de hints, tooltips y tour.
 * Storage keys, configuraciones y constantes del sistema de ayuda.
 * 
 * ✅ v10.5.146: Sistema de onboarding fase 1
 */

// ============================================
// STORAGE KEYS
// ============================================

export const STORAGE_KEYS = {
  // Hints
  LAST_SYNC: 'ml-last-sync',
  LAST_PUBLISH: 'ml-last-publish',
  HINT_PENDING_CLOSED: 'ml-hint-pending-closed',
  HINT_WELCOME_CLOSED: 'ml-hint-welcome-closed',
  HINT_BACKUP_CLOSED: 'ml-hint-backup-closed',
  HINT_PUBLISH_CLOSED: 'ml-hint-publish-closed',
  HINT_BACKUP_DISABLED: 'ml-hint-backup-disabled',
  HINT_PUBLISH_DISABLED: 'ml-hint-publish-disabled',
  
  // Tooltips (v10.5.147)
  TOOLTIP_BACKUP_SEEN: 'ml-tooltip-backup-seen',
  TOOLTIP_PUBLISH_SEEN: 'ml-tooltip-publish-seen',
  TOOLTIP_PROGRESS_SEEN: 'ml-tooltip-progress-seen',
  TOOLTIP_ACCOUNTS_SEEN: 'ml-tooltip-accounts-seen',
  TOOLTIP_RESUME_SEEN: 'ml-tooltip-resume-seen',
  
  // Tour (v10.5.148)
  TOUR_COMPLETED: 'ml-tour-completed'
};

// ============================================
// CONFIGURACIÓN DE HINTS
// ============================================

export const HINT_CONFIG = {
  pending: {
    id: 'pending',
    icon: '⚠️',
    title: 'Tienes procesos pendientes',
    color: 'warning',
    priority: 1,
    getActions: (data) => [
      { 
        text: '▶️ Reanudar Ahora', 
        primary: true,
        action: 'resumePending'
      },
      { 
        text: 'Ver detalles', 
        action: 'goToProgressTab'
      }
    ]
  },
  welcome: {
    id: 'welcome',
    icon: '👋',
    title: '¡Bienvenido a MitikLive!',
    color: 'success',
    priority: 2,
    getActions: () => [
      { 
        text: '💾 Hacer Mi Primer Backup', 
        primary: true,
        action: 'doBackup'
      }
    ]
  },
  'no-backup': {
    id: 'no-backup',
    icon: '💡',
    title: 'Sugerencia',
    color: 'info',
    priority: 3,
    snoozeHours: 24,
    getActions: () => [
      { 
        text: '💾 Hacer Backup Ahora', 
        primary: true,
        action: 'doBackup'
      },
      { 
        text: 'Recordar mañana', 
        action: 'snooze'
      }
    ]
  },
  'no-publish': {
    id: 'no-publish',
    icon: '💭',
    title: 'Recordatorio',
    color: 'brand',
    priority: 4,
    snoozeHours: 48,
    getActions: () => [
      { 
        text: '📤 Publicar Ahora', 
        primary: true,
        action: 'goToPublishTab'
      },
      { 
        text: 'No mostrar más', 
        action: 'disable'
      }
    ]
  }
};

// ============================================
// CONFIGURACIÓN DE TOOLTIPS
// ============================================

export const TOOLTIP_CONFIG = {
  backup: {
    id: 'backup',
    selector: '#btn-backup',
    message: '💾 Guarda tus anuncios localmente para no perderlos',
    position: 'bottom'
  },
  publish: {
    id: 'publish',
    selector: '#btn-publish-dynamic',
    message: '📤 Sube anuncios seleccionados a Wallapop',
    position: 'bottom'
  },
  progress: {
    id: 'progress',
    selector: '[data-tab="in_progress"]',
    message: '📊 Monitorea publicaciones en tiempo real',
    position: 'right'
  },
  accounts: {
    id: 'accounts',
    selector: '#sel-account',
    message: '👤 Cambia entre tus cuentas de Wallapop',
    position: 'bottom'
  },
  resume: {
    id: 'resume',
    selector: '#btn-resume-pending',
    message: '▶️ Continúa proceso interrumpido',
    position: 'bottom'
  }
};

// ============================================
// CONFIGURACIÓN DEL TOUR
// ============================================

export const TOUR_STEPS = [
  {
    step: 1,
    total: 5,
    selector: '#btn-backup',
    title: '💾 Paso 1: Backup',
    message: 'Haz backup de tus anuncios para no perder información. Es el primer paso esencial.',
    position: 'bottom',
    highlight: true
  },
  {
    step: 2,
    total: 5,
    selector: '#sel-account',
    title: '👤 Paso 2: Cuentas',
    message: 'Cambia entre tus cuentas de Wallapop desde aquí. Cada cuenta se gestiona por separado.',
    position: 'bottom',
    highlight: true
  },
  {
    step: 3,
    total: 5,
    selector: '.ml-listings-table-wrapper',
    title: '📋 Paso 3: Tus Anuncios',
    message: 'Aquí verás todos tus anuncios sincronizados. Puedes seleccionarlos, editarlos y gestionarlos.',
    position: 'top',
    highlight: true
  },
  {
    step: 4,
    total: 5,
    selector: '#btn-publish-dynamic',
    title: '📤 Paso 4: Publicar',
    message: 'Selecciona anuncios y publícalos automáticamente. Mantén tus anuncios en primeras posiciones.',
    position: 'bottom',
    highlight: true
  },
  {
    step: 5,
    total: 5,
    selector: '[data-tab="in_progress"]',
    title: '📊 Paso 5: Seguimiento',
    message: '¡Perfecto! Monitorea tus publicaciones en tiempo real desde la pestaña "En Curso".',
    position: 'right',
    highlight: true
  }
];

// ============================================
// UMBRALES Y TIEMPOS
// ============================================

export const THRESHOLDS = {
  BACKUP_DAYS: 7,      // Días sin backup para mostrar hint
  PUBLISH_DAYS: 14,    // Días sin publicar para mostrar hint
  SNOOZE_BACKUP: 24,   // Horas de snooze para backup
  SNOOZE_PUBLISH: 48   // Horas de snooze para publicar
};

// ============================================
// TIMEOUTS
// ============================================

export const TIMEOUTS = {
  TOOLTIP_WAIT: 1000,    // ms para esperar elemento en DOM (aumentado)
  TOOLTIP_RETRY: 10000   // ms timeout total (aumentado)
};
