/**
 * Acciones de los hints y onboarding
 * @module onboarding/actions
 * 
 * Centraliza todas las acciones que pueden ejecutar los hints, tooltips y tour.
 * Funciones para navegar, ejecutar botones y gestionar el flujo del usuario.
 * 
 * ✅ Sigue REGLA #11: Acciones relacionadas en un solo módulo
 * ✅ v10.5.146: Sistema de onboarding fase 1
 */

import { logger } from '../logger.js';

const filepath = 'onboarding/actions.js';

// ============================================
// ACCIONES DE NAVEGACIÓN
// ============================================

/**
 * Ir a pestaña En Curso
 */
export function goToProgressTab() {
  logger.debug(`[${filepath}] Acción: Ver En Curso`);
  const progressTab = document.querySelector('[data-tab="progress"]');
  if (progressTab) {
    progressTab.click();
  } else {
    logger.warn(`[${filepath}] Pestaña En Curso no encontrada`);
  }
}

/**
 * Ir a pestaña Mi Cuenta (para publicar)
 */
export function goToPublishTab() {
  logger.debug(`[${filepath}] Acción: Ir a Mi Cuenta`);
  const accountTab = document.querySelector('[data-tab="account"]');
  if (accountTab) {
    accountTab.click();
  } else {
    logger.warn(`[${filepath}] Pestaña Mi Cuenta no encontrada`);
  }
}

// ============================================
// ACCIONES DE BOTONES
// ============================================

/**
 * Hacer backup
 */
export function doBackup() {
  logger.debug(`[${filepath}] Acción: Hacer backup`);
  const btnBackup = document.getElementById('btn-backup');
  if (btnBackup && !btnBackup.disabled) {
    btnBackup.click();
  } else {
    logger.warn(`[${filepath}] Botón backup no disponible`, { 
      found: !!btnBackup, 
      disabled: btnBackup?.disabled 
    });
  }
}

/**
 * Reanudar procesos pendientes
 */
export function resumePending() {
  logger.debug(`[${filepath}] Acción: Reanudar pendientes`);
  const btnResume = document.getElementById('btn-resume-pending');
  if (btnResume && !btnResume.disabled) {
    btnResume.click();
  } else {
    logger.warn(`[${filepath}] Botón reanudar no disponible`, {
      found: !!btnResume,
      disabled: btnResume?.disabled
    });
  }
}

/**
 * Publicar anuncios seleccionados
 */
export function publishSelected() {
  logger.debug(`[${filepath}] Acción: Publicar seleccionados`);
  const btnPublish = document.getElementById('btn-publish-selected');
  if (btnPublish && !btnPublish.disabled) {
    btnPublish.click();
  } else {
    logger.warn(`[${filepath}] Botón publicar no disponible`, {
      found: !!btnPublish,
      disabled: btnPublish?.disabled
    });
  }
}
