/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/menu.js – Rol: Menú de cabecera (open/close/toggle + listeners)
    Descripcion de todo el proyecto:
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI
            (login JWT, export/import, backups/renovaciones).
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función, solo cambiarlos si se modifica la funcion.
    En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa linea de rol
*/

import { btnMenu, menuPop, miConfig, miLogout, btnPopout, btnPopoutTab } from './state.js';
import { logger } from './logger.js';

import { toast } from '../utils.js';
import { stRemove } from './storage.js';
import { sw } from './runs.js';
import { setAuthUI, setRunControls } from './ui.js'; // ✅ v5.1.0: hideRunUI eliminado
import { paintNotDetected, setBadgeTitle } from './ui.js';
import { openLegal, closeLegal } from './ui.js';

export function openMenu(){
  if (!menuPop) return;
  menuPop.hidden = false;
  btnMenu?.setAttribute('aria-expanded', 'true');
}

export function closeMenu(){
  if (!menuPop) return;
  menuPop.hidden = true;
  btnMenu?.setAttribute('aria-expanded', 'false');
}

export function toggleMenu(){
  if (!menuPop) return;
  menuPop.hidden ? openMenu() : closeMenu();
}

/* ===============
   Init del módulo
   =============== */
let _inited = false;

export function init() {
  if (_inited) return;
  _inited = true;

  // Toggle del menú
  if (btnMenu) {
    btnMenu.addEventListener('click', (e) => {
      e.stopPropagation();
      toggleMenu();
    });
  }

  // Cerrar al click fuera
  document.addEventListener('click', (e) => {
    if (!menuPop || menuPop.hidden) return;
    if (!e.target.closest('.ml-menu')) closeMenu();
  });

  // Cerrar con ESC
  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && !menuPop?.hidden) closeMenu();
  });

  // Abrir configuración
  if (miConfig) {
    miConfig.addEventListener('click', () => {
      closeMenu();
      toast('Abrir configuración (pendiente)', 'ok');
    });
  }

  // Logout - Llamar a handleLogout() de panel.js
  if (miLogout) {
    miLogout.addEventListener('click', () => {
      closeMenu();
      // Llamar a la función global handleLogout definida en panel.js
      if (typeof window.handleLogout === 'function') {
        window.handleLogout();
      }
    });
  }

  // Abrir en ventana popup
  if (btnPopout) {
    btnPopout.addEventListener('click', () => {
      chrome.windows.create({
        url: chrome.runtime.getURL('panel.html?mode=popup'),
        type: 'popup',
        width: 560,
        height: 820
      });
    });
  }
  
  // ✅ v10.5.144: Botón popout en pestañas (mismo comportamiento)
  if (btnPopoutTab) {
    btnPopoutTab.addEventListener('click', () => {
      chrome.windows.create({
        url: chrome.runtime.getURL('panel.html?mode=popup'),
        type: 'popup',
        width: 560,
        height: 820
      });
    });
  }

  // Abrir páginas legales desde cualquier elemento con [data-legal]
  document.addEventListener('click', (ev) => {
    const el = ev.target.closest?.('[data-legal]');
    if (!el) return;
    ev.preventDefault();
    const which = el.getAttribute('data-legal'); // "terminos" | "cookies"
    closeMenu();
    openLegal(which);
  });
}