/**
 * Configuración y constantes del módulo listings
 * @module listings/config
 */

/**
 * Filtros disponibles para los anuncios
 */
export const FILTERS = {
  ALL: 'all',
  ACTIVE: 'active',
  DELETED: 'deleted',
  SOLD: 'sold',
  RESERVED: 'reserved',
  PUBLISHING: 'publishing'
};

/**
 * Modos de botones de acción
 */
export const BUTTON_MODES = {
  DELETE: 'delete',
  PUBLISH: 'publish'
};

/**
 * Configuración de paginación y carga
 */
export const CONFIG = {
  /** Tamaño de chunk para renderizado progresivo */
  CHUNK_SIZE: 20,
  
  /** Límite de items por petición */
  ITEMS_PER_PAGE: 50,
  
  /** Tiempo de debounce para búsqueda (ms) */
  SEARCH_DEBOUNCE: 300,
  
  /** Threshold para activar scroll infinito */
  SCROLL_THRESHOLD: 200
};
