/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/image-modal.js – Rol: Modal para ampliar imágenes de listings
    Descripcion de todo el proyecto:
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI
            (login JWT, export/import, backups/renovaciones).
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función.
    
    ✅ v10.5.32: Refactorizado para usar base-modal.js
*/

import { logger } from './logger.js';
import { createModal, closeModal } from './base-modal.js';

const MODAL_ID = 'image-modal-overlay';

/**
 * Muestra un modal con la imagen ampliada
 * @param {string} imageSrc - URL de la imagen
 * @param {string} title - Título alternativo de la imagen
 */
export function showImageModal(imageSrc, title = '') {
  try {
    // Crear contenido del modal
    const content = `
      <div class="image-modal-content">
        <button class="image-modal-close" title="Cerrar (ESC)">×</button>
        <img class="image-modal-img" src="${imageSrc}" alt="${title}">
      </div>
    `;
    
    // Crear modal usando base-modal
    const modal = createModal({
      id: MODAL_ID,
      overlayClass: 'image-modal-overlay',
      content,
      closeOnOverlayClick: true,
      closeOnEsc: true,
      onOpen: (overlay) => {
        // Configurar botón de cerrar
        const closeBtn = overlay.querySelector('.image-modal-close');
        if (closeBtn) {
          closeBtn.addEventListener('click', (e) => {
            e.stopPropagation();
            closeModal(MODAL_ID);
          });
        }
        
        // Prevenir propagación en el contenido
        const modalContent = overlay.querySelector('.image-modal-content');
        if (modalContent) {
          modalContent.addEventListener('click', (e) => {
            e.stopPropagation();
          });
        }
      }
    });
    
    if (!modal) {
      logger.error('[ImageModal] No se pudo crear el modal');
    }
  } catch (error) {
    logger.error('[ImageModal] ERROR EN showImageModal:', error);
    logger.error('[ImageModal] Stack:', error.stack);
  }
}

/**
 * Cierra el modal de imagen
 */
export function closeImageModal() {
  closeModal(MODAL_ID);
}

/**
 * Inicializa los event listeners para las imágenes de la tabla
 * Debe llamarse después de renderizar la tabla
 */
export function initImageModalListeners() {
  // Buscar todas las imágenes de listings (clase .listing-thumb)
  const images = document.querySelectorAll('.listing-thumb');
  
  images.forEach((img, index) => {
    // Asegurar que tiene cursor zoom-in
    img.style.cursor = 'zoom-in';
    img.title = 'Click para ampliar';
    
    // Crear nuevo listener (no clonar, solo añadir)
    // Primero eliminar listeners anteriores
    const newImg = img.cloneNode(true);
    img.parentNode.replaceChild(newImg, img);
    
    // Añadir event listener al nuevo elemento
    newImg.addEventListener('click', function(e) {
      e.stopPropagation(); // Evitar que active otros clicks
      e.preventDefault();
      
      // Intentar obtener la imagen más grande disponible
      const currentSrc = this.src;
      const fullSrc = currentSrc
        .replace('/small/', '/xlarge/')
        .replace('/medium/', '/xlarge/')
        .replace('/large/', '/xlarge/');
      
      const title = this.alt || 'Imagen del anuncio';
      
      showImageModal(fullSrc, title);
    });
  });
  
  if (images.length === 0) {
  }
}
