/**
 * ============================================
 * DOM UTILITIES - Utilidades DOM Centralizadas
 * ============================================
 * 
 * Funciones utilitarias para manipulación DOM común.
 * Reemplaza manipulaciones inline de estilos por clases CSS.
 * 
 * @module dom-utils
 */

export const DOMUtils = {
  /**
   * Oculta un elemento usando clase CSS
   * @param {HTMLElement|null} element - Elemento a ocultar
   */
  hide(element) {
    if (!element) return;
    element.classList.add('ml-hidden');
  },

  /**
   * Muestra un elemento removiendo clase de ocultación
   * @param {HTMLElement|null} element - Elemento a mostrar
   */
  show(element) {
    if (!element) return;
    element.classList.remove('ml-hidden');
  },

  /**
   * Alterna visibilidad de un elemento
   * @param {HTMLElement|null} element - Elemento a alternar
   * @param {boolean} [show] - Si se especifica, fuerza mostrar/ocultar
   */
  toggle(element, show) {
    if (!element) return;
    
    if (typeof show === 'boolean') {
      element.classList.toggle('ml-hidden', !show);
    } else {
      element.classList.toggle('ml-hidden');
    }
  },

  /**
   * Verifica si un elemento está oculto
   * @param {HTMLElement|null} element - Elemento a verificar
   * @returns {boolean} - true si está oculto
   */
  isHidden(element) {
    if (!element) return true;
    return element.classList.contains('ml-hidden');
  },

  /**
   * Oculta múltiples elementos
   * @param {...HTMLElement} elements - Elementos a ocultar
   */
  hideAll(...elements) {
    elements.forEach(el => this.hide(el));
  },

  /**
   * Muestra múltiples elementos
   * @param {...HTMLElement} elements - Elementos a mostrar
   */
  showAll(...elements) {
    elements.forEach(el => this.show(el));
  }
};

// Exportar por defecto también
export default DOMUtils;
