/*  Cabecera obligatoria: NO BORRAR NI MODIFICAR este bloque inicial en ningún fichero.
    Archivo: scripts/panel/bus.js – Rol: Event Bus mínimo (pub/sub) para módulos del panel
    Descripcion de todo el proyecto:
         MitikLive Wallapop (MV3): panel lateral en Wallapop para gestionar anuncios conectado a FastAPI
            (login JWT, export/import, backups/renovaciones).
    Aviso: NO BORRAR los comentarios descriptivos situados encima de cada función, solo cambiarlos si se modifica la funcion.
    En Rol (linea mas arriba): si está vacía o el fichero se modifica o reestructura, modificar esa linea de rol
*/

export const Bus = (() => {
  const ev = new Map();

  /** Suscribe un handler y devuelve un unsubscribe. */
  function on(type, fn) {
    if (!ev.has(type)) ev.set(type, new Set());
    ev.get(type).add(fn);
    return () => off(type, fn);
  }

  /** Quita un handler. */
  function off(type, fn) {
    const s = ev.get(type);
    if (!s) return;
    s.delete(fn);
    if (s.size === 0) ev.delete(type);
  }

  /** Emite un evento a los suscriptores. */
  function emit(type, payload) {
    const s = ev.get(type);
    if (!s) return;
    for (const fn of s) {
      try { fn(payload); }
      catch (e) { /* handler error silenced */ }
    }
  }

  return { on, off, emit };
})();
