// ============================================================
// 🔘 BOTÓN FLOTANTE PARA ABRIR PANEL
// ============================================================

// Solo ejecutar en la página principal, no en iframes
if (window === window.top) {
  
  // Crear botón flotante
  const button = document.createElement('button');
  button.id = 'mitiklive-open-panel-btn';
  button.innerHTML = `Panel`;
  button.title = 'Abrir panel MitikLive';
  
  // Estilos del botón
  Object.assign(button.style, {
    position: 'fixed',
    bottom: '20px',
    right: '20px',
    padding: '12px 20px',
    borderRadius: '25px',
    backgroundColor: '#2563eb',
    color: 'white',
    border: 'none',
    cursor: 'pointer',
    boxShadow: '0 4px 12px rgba(0,0,0,0.3)',
    zIndex: '999999',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    transition: 'all 0.3s ease',
    fontFamily: 'system-ui, -apple-system, sans-serif',
    fontSize: '14px',
    fontWeight: '600',
    letterSpacing: '0.5px'
  });
  
  // Hover effect
  button.addEventListener('mouseenter', () => {
    button.style.transform = 'scale(1.1)';
    button.style.backgroundColor = '#1d4ed8';
  });
  
  button.addEventListener('mouseleave', () => {
    button.style.transform = 'scale(1)';
    button.style.backgroundColor = '#2563eb';
  });
  
  // Click para abrir panel
  button.addEventListener('click', async () => {
    
    try {
      // Enviar mensaje al service worker para abrir panel
      const response = await chrome.runtime.sendMessage({ 
        type: 'OPEN_PANEL'
      });
      
      if (response?.ok) {
        
        // Ocultar botón temporalmente (el panel ya está visible)
        button.style.opacity = '0.3';
        button.disabled = true;
        
        setTimeout(() => {
          button.style.opacity = '1';
          button.disabled = false;
        }, 2000);
      } else {
        console.error('[MitikLive] ❌ Error al abrir panel:', response?.error);
      }
    } catch (err) {
      // Error común: Extension context invalidated (recarga de extensión)
      if (err.message?.includes('Extension context invalidated')) {
        
        // Mostrar mensaje al usuario
        button.innerHTML = '🔄 F5';
        button.title = 'La extensión se recargó. Presiona F5 para refrescar la página';
        button.style.backgroundColor = '#f59e0b';
      } else {
        console.error('[MitikLive] ❌ Error:', err);
      }
    }
  });
  
  // Agregar al DOM cuando esté listo
  if (document.body) {
    document.body.appendChild(button);
  } else {
    window.addEventListener('DOMContentLoaded', () => {
      document.body.appendChild(button);
    });
  }
}
