/**
 * MitikLive Milanuncios - Estado Global
 * Centraliza todo el estado de la aplicación
 */

// ==================== CONSTANTES ====================

export const API_BASE_URL = 'https://www.mitiklive.com/fa/api';
export const RENOVATIONS_PER_CREDIT = 5;
export const MAX_RETRIES = 3;
export const DELAY_VARIANCE = 0.3;

// ==================== ESTADO ====================

export const state = {
  // Anuncios
  ads: [],
  renovatedIds: new Set(),
  totalActiveAds: null,
  pagination: {
    current: 1,
    total: 1
  },
  
  // Conexión
  currentTabId: null,
  currentMilUserId: null,  // userId del usuario de Milanuncios (no MitikLive)
  currentMilUsername: null,  // username/alias del usuario de Milanuncios
  
  // Renovación
  isRenewing: false,
  stopRequested: false,
  renovationCount: 0,
  renewCallback: null,       // Callback para resultado de renovación
  adsUpdateCallback: null,   // Callback para actualización de anuncios
  
  // Usuario
  userId: null,
  jwt: null,
  credits: 0,
  
  // Stats
  stats: {
    renovatedToday: 0,
    cooldownToday: 0,
    errorsToday: 0,
    lastRenewal: null
  },
  
  // Config
  config: {
    autoRefresh: false,
    delay: 3000,
    notifications: true,
    sound: true,
    zoom: 100
  }
};

// ==================== HELPERS ====================

/**
 * Resetea el estado de renovación
 */
export function resetRenewalState() {
  state.isRenewing = false;
  state.stopRequested = false;
}

/**
 * Marca un anuncio como renovado en esta sesión
 */
export function markAsRenovated(adId) {
  state.renovatedIds.add(String(adId));
}

/**
 * Verifica si un anuncio fue renovado en esta sesión
 */
export function wasRenovatedThisSession(adId) {
  return state.renovatedIds.has(String(adId));
}
