
## v5.8.3 - Fix: Versión dinámica en footer Milanuncios (2025-12-05)

### 🐛 PROBLEMA CORREGIDO

**Síntoma:** El footer de Milanuncios mostraba versión hardcodeada "v5.3.9".

**Solución:** Leer versión dinámicamente con `chrome.runtime.getManifest().version`, igual que Wallapop.

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.js` - Carga versión del manifest al iniciar

---

## v5.8.11 - Fix orden de inicialización JWT (2025-12-05)

### 🐛 CORRECCIÓN

**Problema:** "No hay sesión activa" al conectar

**Causa raíz:** Orden incorrecto en la inicialización:
```
ANTES (mal):
1. initConnectionListener() → dispara handleConnectionStatusChange()
2. state.jwt = jwt        → se asigna DESPUÉS (demasiado tarde)

AHORA (bien):
1. state.jwt = jwt        → se asigna PRIMERO
2. initConnectionListener() → state.jwt ya tiene valor
```

**Cambios:**
- Movida la carga de JWT/user ANTES de `initConnectionListener()`
- `verifyMilanunciosAccount()` usa `state.jwt` directamente (igual que credits.js)

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.js` - Reordenado init + simplificado verifyMilanunciosAccount

---

## v5.8.10 - Fix JWT para verificación de cuenta (2025-12-05)

### 🐛 CORRECCIÓN

**Fix "No hay sesión activa":**
- El JWT puede estar en `session.access` o `jwt` en storage
- Ahora usa `state.jwt` primero (ya cargado en init)
- Fallback a storage buscando ambas claves
- Importado `API_BASE_URL` de state.js

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.js` - Fix obtención de JWT en `verifyMilanunciosAccount()`

---

## v5.8.9 - Verificación de cuenta al conectar (2025-12-05)

### 🔒 MEJORA ANTI-ABUSO

**Verificación al detectar usuario (igual que Wallapop):**
- Ahora verifica la cuenta de Milanuncios al detectar conexión con usuario nuevo
- Si la cuenta ya está vinculada a otro usuario → Bloquea inmediatamente + modal
- Se mantiene verificación al renovar como respaldo

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.js` - `handleConnectionStatusChange()` ahora es async y verifica cuenta

---

## v5.8.8 - Modal cuenta duplicada usa showModal compartido (2025-12-05)

### 🔧 MEJORAS

**Modal de cuenta duplicada:**
- Ahora usa `showModal()` de `scripts/utils.js` (compartido con Wallapop)
- Mismo estilo y comportamiento que en panel de Wallapop
- Links de contacto: WhatsApp y Email

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.js` - Import de showModal + modal mejorada

---

## v5.8.7 - Sistema anti-abuso cuentas Milanuncios (2025-12-05)

### 🔒 SISTEMA ANTI-ABUSO

**Nueva verificación de cuentas de Milanuncios:**
- Al iniciar renovación masiva, verifica si la cuenta de Milanuncios ya está asociada a otro usuario
- Si está duplicada: muestra alerta y bloquea la renovación
- Evita que usuarios creen múltiples cuentas de panel para aprovecharse de créditos de cortesía

**Backend:**
- Nueva tabla `milanuncios_accounts` (similar a `walla_accounts`)
- Nuevo endpoint `POST /api/milanuncios/accounts`
- Suspende automáticamente usuarios que intentan vincular cuentas duplicadas

### 📝 Archivos Modificados

**Backend:**
- `app/routers/milanuncios.py` - Nuevo router con endpoint de cuentas
- `app/main.py` - Router registrado
- `milanuncios_accounts.sql` - SQL para crear tabla

**Extensión:**
- `milanuncios/scripts/state.js` - Añadido `currentMilUsername`
- `milanuncios/scripts/connection.js` - Guarda username al conectar
- `milanuncios/panel-milanuncios.js` - `verifyMilanunciosAccount()` antes de renovar

---

## v5.8.6 - Contador de cuenta atrás + Slider delay extendido (2025-12-05)

### ✨ NUEVAS FUNCIONALIDADES

**Contador de cuenta atrás en footer:**
- Durante la renovación masiva, muestra el tiempo restante hasta el próximo anuncio
- Aparece en el centro del footer con animación pulse
- Se oculta automáticamente al terminar el delay o al parar renovación

**Slider delay extendido:**
- Ahora permite valores de 2 a 30 segundos (antes 2-10s)
- 30 segundos es seguro: el SW no se duerme (límite ~30s inactividad)

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.html` - Contador en footer + slider max=30
- `milanuncios/styles/milanuncios.css` - Estilos del contador
- `milanuncios/scripts/ui.js` - Funciones showCountdown, hideCountdown, startCountdown, stopCountdown
- `milanuncios/panel-milanuncios.js` - randomDelay ahora muestra countdown
- `milanuncios/guia_panel_milanuncios.md` - Actualizada a v2.6.0

---

## v5.8.5 - Fix: Auto-refresh funcionando correctamente (2025-12-05)

### 🐛 CORRECCIONES

**Auto-refresh ahora funciona:**
- El toggle "Auto-actualizar" ahora inicia correctamente el escaneo cada 30 segundos
- Bug: `startAutoRefresh()` se llamaba sin el callback `scanAds`, por lo que nunca ejecutaba nada

### 📝 Archivos Modificados

- `milanuncios/scripts/config.js` - `loadConfig()` ya no inicia auto-refresh (lo hace el panel)
- `milanuncios/panel-milanuncios.js` - Inicia auto-refresh después de cargar config con callback correcto

---

## v5.8.4 - UI Config Milanuncios mejorada (2025-12-05)

### 🎨 MEJORAS UI

**Panel Config de Milanuncios:**
- Card "Exportar a CSV" ahora ocupa 1 columna (igual que las demás)
- Botón "Recargar créditos" ya no ocupa todo el ancho de la card
- Botón "Exportar mis anuncios" ya no ocupa todo el ancho de la card
- Mayor separación entre el grid y los botones Manual/Cerrar sesión
- Añadida línea separadora antes de los botones de acción

### 📝 Archivos Modificados

- `milanuncios/panel-milanuncios.html` - Reestructuración del grid de config
- `milanuncios/styles/milanuncios.css` - Estilos de separación mejorados

---

## v5.8.3 - Preferencias Milanuncios sincronizadas con backend (2025-12-05)

### ✨ NUEVA FUNCIONALIDAD

**Preferencias de Milanuncios persistentes en BD:**

Las preferencias del panel de Milanuncios ahora se guardan en el backend (columna `ui_preferences` de la tabla `users`), permitiendo sincronización entre dispositivos.

**Campos nuevos en el backend:**
- `zoom_milanuncios` - Zoom del panel (70-130%)
- `active_tab_milanuncios` - Pestaña activa (renovaciones, estadisticas, config)
- `delay_milanuncios` - Delay entre anuncios (2-10 segundos)
- `notifications_milanuncios` - Mostrar alertas (true/false)
- `auto_refresh_milanuncios` - Auto-actualizar cada 30s (true/false)
- `sound_milanuncios` - Sonido al terminar (true/false)

**Flujo:**
1. Al abrir panel: carga config local (rápido) → sincroniza con backend
2. Al cambiar config: guarda local (inmediato) + envía al backend (async)

### 🐛 CORRECCIONES

- Footer de Milanuncios ahora lee versión del manifest dinámicamente

### 📝 Archivos Modificados

**Backend:**
- `app/schemas.py` - Nuevos campos en UIPreferences

**Extensión:**
- `milanuncios/scripts/config.js` - Sincronización con backend
- `milanuncios/scripts/ui.js` - switchTab guarda tab activa
- `milanuncios/panel-milanuncios.js` - Carga tab activa al iniciar + versión dinámica

---

## v5.8.2 - Fix: Redirección directa a Milanuncios sin flash (2025-12-05)

### 🐛 PROBLEMA CORREGIDO

**Síntoma:** Al seleccionar Milanuncios y hacer login, se veía por milésimas de segundos el panel de Wallapop antes de redirigir.

**Causa:** La función `setAuthUI()` mostraba `block-app` (Wallapop) primero, y luego un MutationObserver detectaba el cambio y redirigía con 300ms de delay.

**Solución:** Verificar `selectedPlatform` ANTES de mostrar `block-app`. Si es milanuncios, redirigir directamente sin mostrar nada.

### 📝 Archivos Modificados

- `scripts/panel/ui.js` - `setAuthUI()` ahora es async y verifica plataforma

---

## v5.8.1 - UI: Cards login compactas + iconos plataformas (2025-12-05)

### 🎨 MEJORAS VISUALES

**1. Cards de login 50% más compactas:**
- Reducido max-width de 1000px a 700px
- Padding reducido de space-8 a space-4
- Grid de 380px a 200px primera columna
- Tamaños de fuente reducidos proporcionalmente
- Espaciado entre elementos optimizado

**2. Botón Google con texto legible:**
- Color del texto cambiado de #1f1f1f a #202124 con !important
- Borde hover más visible (#c1c1c1)
- Icono SVG reducido a 14x14px

**3. Iconos oficiales de plataformas:**
- Wallapop: Círculo turquesa (#13C1AC) con W estilizada
- Milanuncios: Círculo naranja (#FF6600) con icono casa
- SVG inline (sin dependencias externas)
- Tamaño consistente 24x24px

### 📝 Archivos Modificados

- `styles/panel.css` - Estilos login compactos + botón Google
- `panel.html` - Iconos SVG de plataformas
- `manifest.json` - Versión 5.8.1

---

## v2.5.7 - Fix: Botones Reanudar/Cancelar ocultos durante delay (2025-12-02)

### 🐛 PROBLEMA CORREGIDO

**Síntoma reportado:**
Durante el delay entre anuncios (30s - X horas), los botones "Reanudar" y "Cancelar" aparecían incorrectamente, permitiendo que el usuario interrumpiera el proceso activo.

**Causa raíz:**
1. Anuncio publicado exitosamente → estado `published`
2. Siguiente anuncio en cola → estado `pending`
3. Durante el delay: `processingCount = 0` (ningún item en `processing`)
4. Lógica detectaba: `hasPendingProcess = true` → Botones VISIBLES ❌

**Peligro:** Usuario podía pulsar botones durante delay e interrumpir el proceso.

### ✅ SOLUCIÓN IMPLEMENTADA

**Flag persistente en chrome.storage.local:**
- Nuevo flag: `publish.in_delay`
- Se guarda ANTES de iniciar cada delay
- Se limpia DESPUÉS del delay (en TODOS los casos posibles)
- Se consulta antes de mostrar los botones

**Cobertura completa:**
- ✅ Delay corto (≤60s) con setTimeout
- ✅ Delay largo (>60s) con alarms
- ✅ Pausa larga anti-detección (cada 8-12 anuncios)
- ✅ Errores durante delay (red, pestaña cerrada, etc.)
- ✅ Cancelación manual por usuario
- ✅ Cierre/apertura de panel durante delay
- ✅ Proceso terminado (sin más items)

### 📝 Archivos Modificados

**1. Service Worker - `sw/handlers/publish-process-next.js`**
- Línea ~1370: Guardar flag antes del delay
- Línea ~1430: Limpiar flag después de pausa larga
- Línea ~1485: Limpiar flag después de delay corto
- Línea ~1726: Limpiar flag al despertar de alarm
- Línea ~1640: Limpiar flag en error crítico
- Línea ~1933: Limpiar flag en error de alarm
- Línea ~294: Limpiar flag cuando termina proceso

**2. Panel - `scripts/panel/resume.js`**
- Línea ~133: Consultar flag antes de mostrar botones
- Si `publish.in_delay = true` → Ocultar botones

**3. Panel - `panel.js`**
- Línea ~3138: Limpiar flag al cancelar manualmente

**4. Panel - `scripts/panel/progress-tab.js`**
- Línea ~327: Limpiar flag en resetPublishState()

### 🎯 Comportamiento Corregido

**ANTES (con bug):**
```
Durante delay → Botones VISIBLES ❌
Usuario puede interrumpir → Caos en proceso ❌
```

**DESPUÉS (corregido):**
```
Durante delay → Botones OCULTOS ✓
Proceso continúa automáticamente ✓
Si hay error → Botones aparecen para reanudar ✓
Usuario no puede interrumpir accidentalmente ✓
```

### ✅ Casos de Uso Cubiertos

1. **Delay normal (30s-5min):** Botones ocultos todo el tiempo
2. **Delay largo (horas) con alarm:** Flag se mantiene, botones ocultos
3. **Cierre de panel durante delay:** Flag persiste, al reabrir botones siguen ocultos
4. **Error durante delay:** Flag se limpia, botones aparecen para decidir
5. **Cancelación manual:** Flag se limpia correctamente
6. **Multi-dispositivo:** Si abre en otro PC, flag no existe → puede iniciar nuevo proceso

### 🔗 Referencias

- **REGLA #40:** Lógica de visibilidad de botones (Guía v5.8)
- **REGLA #41:** processingCount actualizado desde progress-tab.js
- Compatible con sistema existente: `publish.paused`, `processingCount`

---

## v2.5.3 - Fix: DISABLE_BUTTON en momento correcto + debugMode controla consola (2025-12-02)

### 🔧 Correcciones

**1. DISABLE_BUTTON movido al momento correcto:**
- **Antes:** Se llamaba después del summary (demasiado pronto, botón no existía)
- **Ahora:** Se llama después de SELECT_CATEGORY, justo antes de FILL_WIDGETS
- El botón de Wallapop ahora se deshabilita cuando el formulario completo está renderizado
- Timeout aumentado de 5s a 8s para dar tiempo al DOM
- Silenciado warning "Botón no encontrado" (no es error crítico)

**Archivos modificados:**
- `sw/handlers/publish-process-next.js` - Reubicado DISABLE_BUTTON
- `content_script.js` - Silenciado warning

**2. debugMode ahora controla TODOS los logs en consola:**
- **Antes:** debugMode solo ocultaba logs DEBUG, INFO/WARN/SUCCESS siempre visibles
- **Ahora:** Con debugMode=false, solo se muestran ERROR en consola
- Los logs siempre se guardan en buffer interno (pestaña Logs del panel)

**Archivos modificados:**
- `scripts/panel/logger.js` - Nueva propiedad `debugMode` que controla salida a consola

---

## v10.5.160 - Fix DEFINITIVO: Tabs Siempre Clickeables (pointer-events CSS) (2025-12-01)

### 🔴 PROBLEMA REPORTADO (INVESTIGACIÓN PROFUNDA)

**Síntoma del usuario:**
> "El click en la pestaña Anuncios funciona al principio, luego se pierde. El cursor se convierte en manita más abajo, no en el botón."

**Investigación realizada:**

1. **✅ Estilos de tabs:** Correctos (panel.css líneas 1201-1280)
2. **✅ z-index de tabs:** Correcto (sticky-controls z-index: 99)
3. **✅ pointer-events del loader:** Correcto (none)
4. **✅ Estructura HTML:** Correcta

**Causa raíz encontrada:**

El `#hints-container` está **hardcodeado en el HTML** (panel.html línea 180):

```html
<!-- Línea 106 -->
<div id="sticky-controls">
  <div class="tabs-container">
    <button data-tab="listings">Anuncios</button>  ← Quieres hacer click
  </div>
</div>

<!-- Línea 138 -->
<section class="ml-body">
  <div class="tab-panel" data-tab-panel="listings">
    <!-- Línea 180 -->
    <div id="hints-container"></div>  ← ❌ Este vacío bloquea
  </div>
</section>
```

**Por qué bloqueaba:**

Aunque aplicamos `pointer-events: none` **en JS** (hints.js línea 267):
```javascript
container.style.pointerEvents = 'none';
```

El **CSS en onboarding.css NO tenía esta propiedad**:
```css
/* onboarding.css (INCORRECTO ❌) */
#hints-container {
  position: relative;
  /* No tenía pointer-events */
}
```

**Timing del problema:**
1. Panel carga → hints-container existe vacío
2. Usuario hace click en tabs → ✅ Funciona
3. Onboarding se inicializa → `ensureHintsContainer()` se ejecuta
4. Aplica `pointer-events: none` en JS
5. Usuario cambia de tab → Se refresca DOM
6. **CSS sin pointer-events toma prioridad**
7. ❌ Tabs bloqueadas

**Por qué se "perdía" después:**
El `pointer-events: none` aplicado en JS no era persistente - al cambiar tabs o refrescar DOM, el CSS tomaba control y como NO tenía la propiedad, volvía al default (`auto`).

---

### ✅ SOLUCIÓN DEFINITIVA

**Añadido `pointer-events: none` al CSS:**

```css
/* onboarding.css (CORRECTO ✅) */
#hints-container {
  position: relative;
  pointer-events: none;  /* ✅ PERMANENTE - No captura clicks */
  /* Los hints dentro lo sobrescriben con auto */
}
```

**Por qué esta solución es definitiva:**

1. **CSS tiene precedencia:** Siempre aplicado, sin importar DOM refreshes
2. **Doble garantía:** CSS + JS = hints-container NUNCA bloquea
3. **Hints funcionan:** Tienen `pointer-events: auto` (hints.js línea 172)

**Estrategia final:**
```
#hints-container (CSS + JS)
  ├─ pointer-events: none → NO captura clicks
  │
  └─ .ml-hint (pointer-events: auto)
      └─ SÍ captura clicks en botones
```

---

### 📋 Cambios

**onboarding.css:**
- Añadido `pointer-events: none` a `#hints-container`
- Comentario explicativo

**Resultado:**
- ✅ Tabs SIEMPRE clickeables (CSS garantizado)
- ✅ No se "pierde" el click después
- ✅ Hints siguen siendo clickeables (auto)
- ✅ Sin timing issues

---

### 🎯 Por qué v2.3.6, v2.3.7, v2.3.8 fallaron

| Versión | Intento | Por qué falló |
|---------|---------|---------------|
| v2.3.6 | CSS `:not(:empty)` | Solo funcionaba si vacío, pero lógica frágil |
| v2.3.7 | JS `pointer-events` | No persistente, DOM refresh lo borraba |
| v2.3.8 | Verificación selectores | No era el problema real |

**v2.4.0 fix:** CSS permanente + JS defensivo = Solución definitiva

---

### Archivos modificados:
- `styles/onboarding.css` - pointer-events: none en CSS
- `manifest.json` - v2.4.0

**IMPORTANTE:** Este fix combina CSS (permanente) + JS (defensivo) para garantizar que hints-container NUNCA bloquee clicks, sin importar el timing de inicialización o refreshes del DOM.

---

## v10.5.160 - Fix DEFINITIVO: Tabs Después del Tour (2025-12-01)

### 🐛 PROBLEMA CRÍTICO

**Usuario reportó:** "El click en la pestaña de anuncios funciona al principio, pero después del tour se vuelve a perder."

**Causa raíz identificada:**

1. **Overlay del tour no se eliminaba completamente**
   - `cleanup()` eliminaba con `setTimeout(300ms)`
   - Pero inmediatamente después se llamaba a `initTooltips()`, `initHelp()`, etc.
   - El overlay seguía existiendo (invisible) bloqueando clicks

2. **hints-container se creaba con pointer-events en conflicto**
   - CSS tenía `pointer-events: none`
   - JS establecía `container.style.pointerEvents = 'none'`
   - Pero sin `!important`, otros estilos podían sobrescribir

**Flujo problemático:**
```
complete()
  ↓
cleanup()  ← setTimeout 300ms (ASYNC)
  ↓
initTooltips()  ← Inmediato (overlay todavía existe)
  ↓
ensureHintsContainer()  ← Crea contenedor
  ↓
❌ Overlay + hints-container bloquean clicks
```

---

### ✅ SOLUCIÓN

**1. Limpieza asíncrona que espera:**

```javascript
// tour.js - complete()
async function complete() {
  await State.markTourCompleted();
  
  // ✅ Esperar a que limpieza termine completamente
  await cleanupAsync();
  
  // Ahora sí, inicializar resto
  await initTooltips();
  initHelp();
  ensureHintsContainer();
}

// Nueva función cleanupAsync
async function cleanupAsync() {
  return new Promise(resolve => {
    // Remover clase active
    if (overlay) overlay.classList.remove('active');
    if (tooltip) tooltip.classList.remove('active');
    
    // Esperar transición + eliminar
    setTimeout(() => {
      if (overlay) {
        overlay.remove();
        overlay = null;
      }
      if (tooltip) {
        tooltip.remove();
        tooltip = null;
      }
      
      // Remover spotlights
      document.querySelectorAll('.ml-tour-spotlight').forEach(el => {
        el.classList.remove('ml-tour-spotlight');
      });
      
      resolve();  // ✅ Promesa resuelta cuando TODO está limpio
    }, 350);  // 300ms transición + 50ms margen
  });
}
```

**2. pointer-events con !important:**

```javascript
// hints.js - ensureHintsContainer()
container.style.setProperty('pointer-events', 'none', 'important');
// ✅ Con !important, NADA puede sobrescribir
```

**Flujo correcto:**
```
complete()
  ↓
await cleanupAsync()  ← Espera 350ms
  ↓
Overlay eliminado completamente ✅
Tooltip eliminado completamente ✅
Spotlights removidos ✅
  ↓
await initTooltips()  ← Ahora sí, DOM limpio
  ↓
ensureHintsContainer()  ← Con pointer-events: none !important
  ↓
✅ Tabs 100% clickeables
```

---

### 📋 Cambios

**tour.js:**
- Nueva función `cleanupAsync()` que devuelve Promise
- `complete()` usa `await cleanupAsync()` antes de continuar
- `cleanup()` síncrono mantenido para `skip()` y `cancel()`
- Timeout aumentado a 350ms (300ms transición + margen)

**hints.js:**
- `setProperty('pointer-events', 'none', 'important')`
- Aplicado tanto al crear como al verificar existente

**Resultado:**
- ✅ Overlay eliminado ANTES de crear nuevo contenido
- ✅ hints-container NUNCA bloquea (con !important)
- ✅ Tabs clickeables después del tour
- ✅ No más conflictos de timing

---

### Archivos modificados:
- `scripts/panel/onboarding/tour.js` - cleanupAsync con await
- `scripts/panel/onboarding/hints.js` - pointer-events con !important
- `manifest.json` - v2.4.0

**IMPORTANTE:** Este fix resuelve el problema de timing entre limpieza del tour e inicialización de módulos post-tour.

---

## v10.5.159 - Refactor: Help.js Según Arquitectura de la Guía (2025-12-01)

### 📚 REVISIÓN SEGÚN GUÍA MAESTRA

**Principio arquitectónico identificado:**
- panel.js verifica `STATE.AUTH.state === 'AUTHENTICATED'`
- Solo llama a módulos si está autenticado
- Los módulos **confían en esta verificación previa**
- No deben duplicar verificaciones de estado global

**REGLA identificada implícitamente:**
> Los módulos deben ser autocontenidos pero NO deben verificar estado de autenticación - eso es responsabilidad del caller (panel.js)

---

### 🔴 PROBLEMA EN v2.3.8

`help.js` duplicaba verificaciones que ya hacía `panel.js`:

```javascript
// help.js v2.3.8 (INCORRECTO ❌)
function createHelpButton() {
  // ❌ Verificación duplicada
  const loginBlock = document.getElementById('block-login');
  if (loginBlock && !loginBlock.hidden) {
    return;  // Verificación de autenticación
  }
  
  // ❌ Verificación de DOM que puede fallar
  const mlBody = document.getElementById('ml-body');
  if (!mlBody) {
    return;
  }
  
  // Crear botón...
}
```

**Problemas:**
1. Duplica lógica de autenticación que ya está en `panel.js`
2. Accede directamente a elementos del DOM en vez de confiar en el flujo
3. No sigue el principio de separación de responsabilidades

---

### ✅ SOLUCIÓN v2.3.9

**Simplificado según arquitectura:**

```javascript
// help.js v2.3.9 (CORRECTO ✅)
function createHelpButton() {
  // Solo verificar duplicados (responsabilidad propia)
  if (helpButton || document.getElementById('ml-help-button')) {
    return;
  }
  
  // Crear botón
  // NOTA: Autenticación verificada en panel.js (STATE.AUTH.state)
  helpButton = document.createElement('button');
  // ...
}
```

**Arquitectura correcta:**

```
panel.js (initPanel)
  ↓
if (STATE.AUTH.state === 'AUTHENTICATED') {  ← ✅ Verificación centralizada
  ↓
  ONBOARDING.init()
    ↓
    Tour.init() o Help.init()
      ↓
      createHelpButton()  ← ✅ Confía en verificación previa
}
```

**Responsabilidades claras:**
- **panel.js:** Verifica autenticación global
- **help.js:** Solo crea botón (confía en caller)
- **NO duplicar lógica:** Single source of truth

---

### 📋 Cambios

**help.js:**
- ❌ Removidas verificaciones de `#block-login`
- ❌ Removidas verificaciones de `#ml-body`
- ✅ Mantenida verificación de duplicados (responsabilidad propia)
- ✅ Comentario explicando confianza en caller

**Beneficios:**
- ✅ Sigue principio de separación de responsabilidades
- ✅ No duplica lógica de autenticación
- ✅ Más simple y mantenible
- ✅ Confía en arquitectura establecida

---

### Archivos modificados:
- `scripts/panel/onboarding/help.js` - Simplificado según guía
- `manifest.json` - v2.3.9

**IMPORTANTE:** Este cambio alinea el código con la arquitectura de la guía donde:
- Estado global se verifica en panel.js
- Módulos son llamados solo cuando deben ejecutarse
- No hay verificaciones duplicadas

---

## v10.5.158 - Fix: Botón Ayuda Selector Correcto (2025-12-01)

### 🐛 PROBLEMA

En v2.3.7, el botón (?) **NO se creaba** porque buscaba selectores incorrectos:

```
[INFO] [onboarding/help.js] Panel principal no encontrado, botón no creado
```

**Causa:**
```javascript
// help.js v2.3.7 (INCORRECTO ❌)
const panelContent = document.querySelector('.ml-panel-content, #ml-panel');
if (!panelContent) {
  return;  // ❌ Estos selectores no existen
}
```

Los selectores `.ml-panel-content` y `#ml-panel` **no existen en el HTML**.

---

### ✅ SOLUCIÓN

**Verificación correcta:**

```javascript
// help.js v2.3.8 (CORRECTO ✅)
function createHelpButton() {
  // 1. No duplicar
  if (helpButton || document.getElementById('ml-help-button')) {
    return;
  }
  
  // 2. Verificar que usuario está autenticado
  const loginBlock = document.getElementById('block-login');
  if (loginBlock && !loginBlock.hidden && loginBlock.style.display !== 'none') {
    return;  // Usuario en login, no crear
  }
  
  // 3. Verificar que existe el body principal
  const mlBody = document.getElementById('ml-body');
  if (!mlBody) {
    return;
  }
  
  // 4. Crear botón
  helpButton = document.createElement('button');
  // ...
}
```

**Estrategia:**
- ✅ Verificar `#block-login` (oculto cuando autenticado)
- ✅ Verificar `#ml-body` (existe siempre)
- ✅ Crear solo si autenticado

---

### 📋 Cambios

**help.js:**
- Cambiado selector de `.ml-panel-content, #ml-panel` a `#ml-body`
- Añadida verificación de `#block-login` para detectar autenticación
- Logs más descriptivos

**Resultado:**
- ✅ Botón (?) se crea correctamente después del login
- ✅ NO se crea en pantalla de login

---

### Archivos modificados:
- `scripts/panel/onboarding/help.js` - Selectores corregidos
- `manifest.json` - v2.3.8

---

## v10.5.157 - Fix: Botón Ayuda Posición + Tabs Definitivo (2025-12-01)

### 🐛 PROBLEMAS REPORTADOS

**1. Botón (?) mal posicionado:**
- Tapaba la versión de la extensión (abajo a la izquierda)
- Aparecía en pantalla de login (no debería)

**2. Tabs volvían a perder click:**
- Funcionaban al principio
- Después dejaban de ser clickeables
- Usuario tenía que hacer click más abajo otra vez

---

### ✅ SOLUCIONES

**1. Botón de ayuda reposicionado:**

```css
/* help.css */
.ml-help-button {
  bottom: 80px;  /* Era 24px, ahora 80px */
  right: 24px;
}
```

**2. Botón NO se crea en login:**

```javascript
// help.js - createHelpButton()
function createHelpButton() {
  // No crear si ya existe
  if (helpButton || document.getElementById('ml-help-button')) {
    return;
  }
  
  // No crear si no estamos en el panel principal
  const panelContent = document.querySelector('.ml-panel-content, #ml-panel');
  if (!panelContent) {
    return;  // Estamos en login, no crear
  }
  
  // Crear botón...
}
```

**3. hints-container con pointer-events: none:**

El problema era que el contenedor se creaba dinámicamente y bloqueaba clicks.

```javascript
// hints.js - ensureHintsContainer()
export function ensureHintsContainer() {
  let container = document.getElementById('hints-container');
  if (!container) {
    container = document.createElement('div');
    container.id = 'hints-container';
    container.style.pointerEvents = 'none';  // ✅ No bloquea clicks
    // ...
  } else {
    // Asegurar que no bloquea si ya existe
    container.style.pointerEvents = 'none';  // ✅
  }
  return container;
}
```

**4. Hints individuales SÍ clickeables:**

```javascript
// hints.js - showHint()
const hint = document.createElement('div');
hint.style.pointerEvents = 'auto';  // ✅ El hint sí recibe clicks
```

**Estrategia pointer-events:**
- **Contenedor:** `pointer-events: none` → NO bloquea tabs
- **Hint individual:** `pointer-events: auto` → SÍ recibe clicks

---

### 📋 Cambios

**help.css:**
- `bottom: 80px` (antes 24px)

**help.js:**
- Verificar que no existe antes de crear
- Verificar que estamos en panel principal (no login)

**hints.js:**
- `hints-container` con `pointer-events: none`
- Hints individuales con `pointer-events: auto`
- Asegurar en `ensureHintsContainer()` siempre

**Resultado:**
- ✅ Botón (?) más arriba, no tapa versión
- ✅ Botón NO aparece en login
- ✅ Tabs SIEMPRE clickeables
- ✅ Hints funcionan correctamente

---

### Archivos modificados:
- `styles/help.css` - Posición del botón
- `scripts/panel/onboarding/help.js` - Verificaciones
- `scripts/panel/onboarding/hints.js` - pointer-events
- `manifest.json` - v2.3.7

---

## v10.5.156 - Fix: Tabs No Clickeables (Hints-Container Bloqueaba) (2025-12-01)

### 🐛 PROBLEMA CRÍTICO

**La pestaña "Anuncios" (y otras tabs) no eran clickeables en su posición real.**

**Síntoma reportado por usuario:**
> "Tengo que hacer click unos 2 centímetros más abajo del botón 'Anuncios' para que funcione. El puntero se convierte en manita solo abajo, no en el botón mismo."

**Causa raíz:**

El `#hints-container` tenía CSS problemático que bloqueaba los clicks:

```css
/* onboarding.css (INCORRECTO ❌) */
#hints-container {
  position: relative;
  z-index: 100;           /* ❌ Innecesario y peligroso */
  margin-bottom: 16px;    /* ❌ Ocupa espacio aunque esté vacío */
}
```

**Por qué bloqueaba:**
1. Se crea ANTES de `listings-section` en el DOM
2. Está **encima de las tabs** visualmente
3. Aunque esté **vacío**, ocupaba espacio por el `margin-bottom`
4. Tenía `z-index: 100` que lo ponía por encima de otros elementos
5. Los clicks en la zona de las tabs caían en el contenedor vacío

**Estructura DOM:**
```
<div class="tabs-container">  ← Tabs aquí
  <button data-tab="listings">Anuncios</button>
</div>
...
<div id="hints-container"></div>  ← ❌ Bloqueaba clicks
<section id="listings-section">
```

---

### ✅ SOLUCIÓN

**CSS corregido:**

```css
/* onboarding.css (CORRECTO ✅) */
#hints-container {
  position: relative;
  /* z-index removido - no necesario */
  /* margin-bottom solo si tiene contenido */
}

/* Solo aplicar margin si tiene hints dentro */
#hints-container:not(:empty) {
  margin-bottom: var(--space-4);
}
```

**Cambios:**
1. ❌ Removido `z-index: 100` (innecesario)
2. ✅ Margin solo si tiene contenido (`:not(:empty)`)
3. ✅ Contenedor vacío no ocupa espacio
4. ✅ No bloquea clicks en elementos superiores

---

### 📋 Resultado

**ANTES (v2.3.5):**
- ❌ Hints-container bloqueaba tabs
- ❌ Click en "Anuncios" no funcionaba
- ❌ Había que hacer click 2cm más abajo

**AHORA (v2.3.6):**
- ✅ Hints-container no bloquea nada
- ✅ Click en "Anuncios" funciona perfectamente
- ✅ Todas las tabs clickeables en su posición real

---

### Archivos modificados:
- `styles/onboarding.css` - Hints-container sin z-index
- `manifest.json` - v2.3.6

**IMPORTANTE:** Este era un bug de CSS, NO de JavaScript. Seguía la guía en cuanto a estructura modular, pero el CSS causaba problemas de interacción.

---

## v10.5.155 - Fix: Botón Ayuda y Hints Después del Tour (2025-12-01)

### 🐛 PROBLEMA CRÍTICO

**Después de completar el tour, NO aparecían:**
- ❌ Botón de ayuda (?)
- ❌ Hints contextuales

**Causa raíz:**

En `tour.js`, la función `complete()` solo inicializaba tooltips:

```javascript
// tour.js - complete() (INCORRECTO ❌)
async function complete() {
  await State.markTourCompleted();
  cleanup();
  
  // Solo inicializa tooltips
  const { init: initTooltips } = await import('./tooltips.js');
  await initTooltips();  // ✅
  // ❌ Faltaba Help
  // ❌ Faltaban Hints
}
```

En `index.js`, cuando el tour se inicia, se hace `return`:

```javascript
// index.js - init() (PROBLEMA)
const tourStarted = await Tour.init();
if (tourStarted) {
  return;  // ❌ Nunca llega a Help.init()
}

Help.init();  // ← Esta línea nunca se ejecutaba
```

**Resultado:**
1. Tour inicia → index.init() retorna
2. Usuario completa tour
3. Tour solo inicializa tooltips
4. ❌ Botón de ayuda NUNCA se crea
5. ❌ Hints NUNCA se evalúan

---

### ✅ SOLUCIÓN

**tour.js - complete() ahora inicializa TODO:**

```javascript
async function complete() {
  await State.markTourCompleted();
  cleanup();
  
  // ✅ Inicializar TODO el sistema
  const { init: initTooltips } = await import('./tooltips.js');
  const { init: initHelp } = await import('./help.js');
  const { ensureHintsContainer, evaluateAndShowHint } = await import('./hints.js');
  
  await initTooltips();  // ✅ Tooltips
  initHelp();            // ✅ Botón de ayuda
  
  // ✅ Hints contextuales
  ensureHintsContainer();
  await evaluateAndShowHint();
}
```

**Ahora cuando el tour termina:**
1. ✅ Marca tour como completado
2. ✅ Limpia overlay y tooltips del tour
3. ✅ Inicializa tooltips con badges
4. ✅ Crea botón de ayuda (?)
5. ✅ Evalúa y muestra hints contextuales

---

### 📋 Cambios

**tour.js:**
- Añadidas importaciones dinámicas de `help.js` y `hints.js`
- Llamadas a `initHelp()` y `evaluateAndShowHint()`

**Resultado:**
- ✅ Botón (?) aparece después del tour
- ✅ Hints contextuales se evalúan
- ✅ Tooltips funcionan
- ✅ Sistema completo funcional

---

### Archivos modificados:
- `scripts/panel/onboarding/tour.js` - complete() mejorado
- `manifest.json` - v2.3.5

---

## v10.5.154 - Fix: Onboarding También Después del Login (2025-12-01)

### 🐛 PROBLEMA

En v2.3.3, el onboarding solo se inicializaba si el usuario **YA estaba autenticado** al abrir el panel.

**Si el usuario hacía login DESPUÉS de abrir el panel, el onboarding NO se inicializaba.**

```
Usuario abre panel → No autenticado → onboarding NO se ejecuta
Usuario hace login → ✅ Cuenta cargada
Usuario espera... → ❌ Onboarding NO aparece (nunca se inicializó)
```

---

### ✅ SOLUCIÓN

**Onboarding ahora se inicializa también en `handleAccountChange()`:**

```javascript
// handleAccountChange() - después de cargar cuenta
if (ONBOARDING?.init && !window._onboardingInitialized) {
  window._onboardingInitialized = true;
  setTimeout(() => {
    ONBOARDING.init();
  }, 1500);
}
```

**Flag global `window._onboardingInitialized`:**
- Evita inicializar múltiples veces
- Se marca tanto en init inicial como en handleAccountChange

**Ahora cubre AMBOS casos:**
1. ✅ Usuario YA autenticado al abrir panel → Init en initPanel()
2. ✅ Usuario hace login DESPUÉS → Init en handleAccountChange()

---

### 📋 Cambios

**panel.js:**
- Añadido flag `window._onboardingInitialized`
- Init en initPanel() marca flag
- Init en handleAccountChange() verifica flag y lo marca

**Resultado:**
- ✅ Onboarding funciona si abres panel ya logueado
- ✅ Onboarding funciona si haces login después de abrir
- ✅ No se inicializa múltiples veces

---

### Archivos modificados:
- `panel.js` - Onboarding también en handleAccountChange()
- `manifest.json` - v2.3.4

---

## v10.5.153 - Fix CRÍTICO: Onboarding Solo Si Autenticado (2025-12-01)

### 🔴 PROBLEMA CRÍTICO

**El onboarding se inicializaba ANTES de hacer login**, causando múltiples errores:

```
[ERROR] Cannot read properties of null (reading 'remove')
[INFO] Badge añadido: #btn-backup  ← ❌ Botón no existe sin login
[INFO] Badge añadido: #btn-publish-dynamic  ← ❌ Botón no existe
[INFO] Badge añadido: [data-tab="in_progress"]  ← ❌ Tab no existe
```

**Causa raíz:** 
```javascript
// panel.js (INCORRECTO)
if (ONBOARDING?.init) {
  setTimeout(() => {
    ONBOARDING.init();  // ❌ Se ejecuta SIN verificar AUTH
  }, 1000);
}
```

El sistema intentaba añadir badges a elementos que **NO EXISTEN** porque el usuario no está autenticado. Los botones de backup, publicar, tabs, etc. solo están disponibles DESPUÉS de hacer login.

---

### ✅ SOLUCIÓN

**Onboarding se inicializa SOLO si usuario está autenticado:**

```javascript
// panel.js (CORRECTO)
if (STATE.AUTH.state === 'AUTHENTICATED') {
  // ✅ Solo ejecutar si autenticado
  if (ONBOARDING?.init) {
    setTimeout(() => {
      ONBOARDING.init();
    }, 1500);  // Aumentado a 1.5s
  }
}
```

**Orden correcto de inicialización:**
```
1. UI básica
2. AUTH verifica sesión
3. Si NO autenticado → Solo login UI
4. Si AUTENTICADO:
   ├─ Cargar cuenta
   ├─ Inicializar módulos (LISTINGS, RESUME, etc.)
   └─ ✅ Inicializar ONBOARDING (ahora aquí)
```

---

### 📋 Cambios

**panel.js:**
- ❌ Removido: Init de ONBOARDING antes de auth
- ✅ Añadido: Init de ONBOARDING DENTRO de `if (STATE.AUTH.state === 'AUTHENTICATED')`
- ✅ Timeout aumentado: 1000ms → 1500ms (más tiempo para DOM)

**Resultado:**
- ✅ Sin errores al abrir panel sin login
- ✅ Onboarding solo se activa si usuario autenticado
- ✅ Todos los elementos existen cuando se añaden badges

---

### Archivos modificados:
- `panel.js` - Onboarding movido a bloque de autenticación
- `manifest.json` - v2.3.3

**CRÍTICO:** Esta era una violación del flujo de inicialización de la guía. Ahora sigue el orden correcto.

---

## v10.5.152 - Fix: Tooltips y Hints - Mejor Gestión de Timing (2025-12-01)

### 🐛 Correcciones Críticas

**PROBLEMAS:**
1. Tooltips intentaban añadirse a elementos ocultos/inexistentes
2. Hint de bienvenida se mostraba aunque tour ya completado
3. Warnings de timeout innecesarios

**SOLUCIONES APLICADAS:**

**1. Tooltips NO se inicializan durante el tour**
```javascript
// tooltips.js - Verificar que tour no esté activo
if (State.isTourActive()) {
  logger.info('Tour activo, tooltips pospuestos');
  return;
}
```

**2. Tooltips se inicializan DESPUÉS del tour**
```javascript
// tour.js - complete()
await State.markTourCompleted();
const { init: initTooltips } = await import('./tooltips.js');
await initTooltips();  // ✅ Inicializar ahora
```

**3. Hint de bienvenida NO si tour completado**
```javascript
// hints.js - evaluateWelcomeHint()
if (await State.isTourCompleted()) return null;  // ✅ No mostrar
```

**4. Timeouts aumentados (REGLA #19)**
```javascript
// config.js
TOOLTIP_WAIT: 1000,    // 500 → 1000ms
TOOLTIP_RETRY: 10000   // 5000 → 10000ms
```

**5. Mejor manejo de timeouts**
- Contador de intentos
- Log debug en vez de warn para elementos opcionales
- Máximo intentos antes de abandonar

### Mejoras:
- ✅ Sin warnings innecesarios
- ✅ Tooltips solo cuando elementos existen
- ✅ Hints contextuales según estado real
- ✅ Tour → Tooltips en secuencia correcta

### Archivos modificados:
- `scripts/panel/onboarding/tooltips.js` - Verificar tour activo + mejor timeout
- `scripts/panel/onboarding/hints.js` - No mostrar bienvenida si tour completado
- `scripts/panel/onboarding/tour.js` - Inicializar tooltips al completar
- `scripts/panel/onboarding/config.js` - Timeouts aumentados
- `manifest.json` - v2.3.2

**Sigue REGLA #19 (timeouts progresivos) y REGLA #15 (espera activa)** ✅

---

## v10.5.151 - Fix: Selectores Correctos en Tour y Tooltips (2025-12-01)

### 🐛 Corrección Crítica

**PROBLEMA:** El tour saltaba pasos 2, 4 y 5 porque los selectores CSS eran incorrectos.

**Errores identificados:**
```
[ERROR] Elemento no encontrado: #account-selector
[ERROR] Elemento no encontrado: #btn-publish-selected
[ERROR] Elemento no encontrado: [data-tab="progress"]
```

**Selectores corregidos:**

| Paso | Antes ❌ | Ahora ✅ | Razón |
|------|---------|---------|-------|
| 2. Cuentas | `#account-selector` | `#sel-account` | ID real del select |
| 4. Publicar | `#btn-publish-selected` | `#btn-publish-dynamic` | Botón unificado v5.0 |
| 5. En Curso | `[data-tab="progress"]` | `[data-tab="in_progress"]` | Nombre real del tab |

**También corregido en tooltips** con los mismos selectores.

### Archivos modificados:
- `scripts/panel/onboarding/config.js` - TOUR_STEPS y TOOLTIP_CONFIG corregidos
- `manifest.json` - v2.3.1

**Ahora el tour muestra los 5 pasos correctamente.** ✅

---

## v10.5.150 - Refactor: Sistema de Onboarding según Guía Maestra (2025-12-01)

### 🔧 Refactorización Crítica

**Reestructuración completa siguiendo TODAS las reglas de la guía:**

✅ **REGLA #1**: Imports desde módulos centralizados (utils.js, logger.js)
✅ **REGLA #4**: Uso de logger.js en lugar de console.log
✅ **REGLA #7**: Reutilización de funciones de utils.js (sleep)
✅ **REGLA #11**: Modularidad estricta - funciones relacionadas juntas
✅ **Patrón listings/**: Estructura idéntica al módulo listings

**Nueva estructura modular:**
```
scripts/panel/onboarding/
├── index.js          → Orquestador principal (API pública)
├── config.js         → Configuración centralizada
├── state.js          → Estado y storage (fuente única de verdad)
├── hints.js          → Gestión de hints contextuales
├── tooltips.js       → Badges pulsantes
├── tour.js           → Tour guiado interactivo
├── help.js           → Modal de ayuda
└── actions.js        → Acciones (navegación, botones)
```

**Arquitectura de estado (igual que listings/module-state.js):**
- `state.js` = Fuente única de verdad
- chrome.storage.local para persistencia
- Sin estado duplicado
- Getters/setters centralizados

**Mejoras respecto a versión anterior:**
- ❌ Eliminados: 3 archivos raíz mal estructurados
- ✅ Modularidad: 8 archivos especializados
- ✅ Imports: Todos desde módulos centralizados
- ✅ Logger: 100% con logger.js
- ✅ Documentación: Cabeceras JSDoc completas
- ✅ Patrones: Idénticos a listings/

**Funcionalidades mantenidas:**
- Hints contextuales (4 tipos)
- Tooltips con badges pulsantes
- Tour guiado con spotlight
- Modal de ayuda permanente

**API pública (window.ONBOARDING):**
```javascript
// Hints
ONBOARDING.refresh()
ONBOARDING.updateLastSync()
ONBOARDING.updateLastPublish()

// Tooltips
ONBOARDING.resetTooltips()

// Tour
ONBOARDING.startTour()
ONBOARDING.resetTour()
ONBOARDING.skipTour()

// Ayuda
ONBOARDING.openHelp()
ONBOARDING.closeHelp()
```

### Archivos modificados:
- `panel.js` - Import del módulo según patrón
- `panel.html` - Sin scripts adicionales (solo panel.js)
- `manifest.json` - v2.3.0

### Archivos eliminados:
- `scripts/panel/onboarding.js` ❌ (mal estructurado)
- `scripts/panel/tour.js` ❌ (no modular)
- `scripts/panel/help.js` ❌ (no seguía patrón)

### Archivos nuevos:
- `scripts/panel/onboarding/index.js`
- `scripts/panel/onboarding/config.js`
- `scripts/panel/onboarding/state.js`
- `scripts/panel/onboarding/hints.js`
- `scripts/panel/onboarding/tooltips.js`
- `scripts/panel/onboarding/tour.js`
- `scripts/panel/onboarding/help.js`
- `scripts/panel/onboarding/actions.js`

**CRÍTICO**: Esta versión es la correcta. Las v2.2.6-2.2.9 NO seguían la guía.

---

## v10.5.149 - Feature: Modal de Ayuda (2025-12-01)

### ✨ Nuevas funcionalidades

**Botón flotante de ayuda (?)**
- Botón azul flotante abajo derecha
- Siempre visible y accesible
- Animación hover con glow
- Click para abrir modal de ayuda

**Modal de ayuda completo**
- Guía rápida integrada
- Reiniciar tour desde el modal
- Consejos rápidos (4 tips)
- FAQs con respuestas expandibles
- Atajos de teclado
- Scrollable y responsive

**Contenido del modal:**
1. 🚀 **Tutorial Paso a Paso** - Reinicia el tour
2. 💡 **Consejos Rápidos** - Backup, horarios, delay, monitoreo
3. ❓ **Preguntas Frecuentes** - 5 FAQs con <details>
4. ⌨️ **Atajos de Teclado** - Ctrl+Click, Doble Click, Esc

**Características:**
- Overlay oscuro con fade
- Animación scale de entrada
- Cerrar con × o click en overlay
- Scrollbar personalizada
- Diseño moderno con grid
- Responsive en móvil

**FAQs incluidas:**
- ¿Cómo hago mi primer backup?
- ¿Cómo publico anuncios?
- ¿Qué pasa si se interrumpe?
- ¿Puedo usar varias cuentas?
- ¿Es seguro?

### Archivos nuevos:
- `scripts/panel/help.js` - Lógica modal ayuda
- `styles/help.css` - Estilos modal + botón

### Archivos modificados:
- `scripts/panel/onboarding.js` - Init HELP
- `panel.html` - Script + CSS help
- `manifest.json` - v2.2.9

---

## v10.5.148 - Feature: Tour inicial completo (2025-12-01)

### ✨ Nuevas funcionalidades

**Tour guiado interactivo con spotlight**
- Aparece SOLO la primera vez
- 5 pasos que explican elementos clave
- Overlay oscuro + spotlight en elemento
- Navegación: Siguiente, Anterior, Saltar
- Animaciones suaves y profesionales

**Pasos del tour:**
1. 💾 **Backup** - "Haz backup para no perder información"
2. 👤 **Selector Cuentas** - "Cambia entre tus cuentas"
3. 📋 **Tabla Anuncios** - "Gestiona tus anuncios sincronizados"
4. 📤 **Publicar** - "Publica automáticamente"
5. 📊 **En Curso** - "Monitorea publicaciones en tiempo real"

**Características:**
- Spotlight con sombra 9999px (efecto cinema)
- Tooltip flotante posicionado inteligente
- Botones: "Siguiente →", "← Anterior", "× Saltar"
- Auto-scroll suave al elemento
- Responsive (ajusta en móvil)
- Se marca como completado en storage
- Bloquea hints hasta terminar

**Funciones debug:**
```javascript
TOUR.reset()  // Resetear tour para volver a verlo
TOUR.start()  // Iniciar tour manualmente
TOUR.skip()   // Saltar tour
```

### Archivos nuevos:
- `scripts/panel/tour.js` - Lógica del tour
- `styles/tour.css` - Estilos spotlight + tooltip

### Archivos modificados:
- `scripts/panel/onboarding.js` - Integración tour
- `panel.html` - Script + CSS tour
- `manifest.json` - v2.2.8

---

## v10.5.147 - Feature: Tooltips interactivos con badges (2025-12-01)

### ✨ Nuevas funcionalidades

**Tooltips mejorados con badges pulsantes** 
- Badge azul pulsante `●` en botones importantes
- Solo aparece en primera vez (nunca visto)
- Desaparece al hacer click en el botón
- Mejora el `title` nativo del navegador

**Tooltips implementados:**
1. 💾 **Backup** - "Guarda tus anuncios localmente"
2. 📤 **Publicar** - "Sube anuncios seleccionados"
3. 📊 **En Curso** - "Monitorea publicaciones en tiempo real"
4. 👤 **Selector Cuentas** - "Cambia entre tus cuentas"
5. ▶️ **Reanudar** - "Continúa proceso interrumpido"

**Características:**
- Badge pulsante azul brillante
- Animación `tooltipPulse` (2s infinite)
- Se marca como "visto" al click
- Storage en `chrome.storage.local`
- No intrusivo (pequeño, en esquina)

**Función debug:**
```javascript
ONBOARDING.resetTooltips() // Resetear todos los tooltips
```

### Archivos modificados:
- `scripts/panel/onboarding.js` - Sistema tooltips
- `styles/onboarding.css` - Estilos badge pulsante
- `manifest.json` - v2.2.7

---

## v10.5.146 - Feature: Sistema de Onboarding - Fase 1 (2025-12-01)

### ✨ Nuevas funcionalidades

**Sistema de hints contextuales inteligentes**
- Hints que aparecen según el contexto del usuario
- Solo 1 hint a la vez (priorizados por importancia)
- Fácil de cerrar (×) o posponer
- Animaciones suaves (slideDown)

**Hints implementados:**
1. ⚠️ **Pendientes** (prioridad 1) - Si hay publish_status pendientes
2. 👋 **Bienvenida** (prioridad 2) - Primera vez con 0 anuncios
3. 💡 **Backup antiguo** (prioridad 3) - Hace >7 días sin backup
4. 💭 **Sin publicar** (prioridad 4) - Hace >14 días sin publicar

**Características:**
- Colores por tipo: warning, success, info, brand
- Botones de acción directos (Reanudar, Backup, etc.)
- Snooze/Deshabilitar permanente
- Storage en `chrome.storage.local`
- Integrado con estado global (STATE)

**Prioridades:**
- Solo muestra el hint más importante
- Se pueden cerrar temporalmente (snooze)
- Se pueden deshabilitar permanentemente

### Archivos nuevos:
- `scripts/panel/onboarding.js` - Sistema de hints
- `styles/onboarding.css` - Estilos hints

### Archivos modificados:
- `panel.html` - Contenedor hints + script
- `panel.js` - Inicialización ONBOARDING
- `manifest.json` - v2.2.6

### Próximas fases:
- v10.5.147: Tooltips interactivos
- v10.6.0: Tour inicial completo
- v10.6.1: Modal de ayuda

---

## v10.5.145 - UX: Scrollbar vertical llamativo (2025-12-01)

### ✨ Mejoras de UX

**Scrollbar VERTICAL visible en tabla de Anuncios**
- Anteriormente estaba oculto (`display: none`)
- Ahora tiene scrollbar personalizado azul llamativo
- **SOLO scroll vertical** (`overflow-x: hidden`)
- Mismo estilo que pestaña "En curso"

**Scrollbars verticales mejorados en ambas pestañas**
- Ancho aumentado: `8px` → `10px` (más visible)
- Color principal: `var(--brand-primary)` azul intenso
- Borde de 2px para separar del track
- Efecto glow al hover (`box-shadow`)
- Background: `var(--bg-secondary)` para contraste

**Nueva variable CSS:**
- `--scrollbar-width: 10px` añadida en `variables.css`
- Reutilizable para futuros scrollbars personalizados

**Cambios visuales:**
- Track: Fondo oscuro definido
- Thumb: Azul brillante (`#3b82f6`)
- Hover: Azul más claro (`#60a5fa`) + glow luminoso
- Border radius: Bordes redondeados suaves

**✅ Cumple reglas de guía:**
- REGLA #2: Usa SOLO variables CSS (no valores hardcoded)
- REGLA #43: Variable `--scrollbar-width` centralizada
- Checklist CSS: 100% variables, sin px/hex directos

### Archivos modificados:
- `styles/variables.css` - Variable `--scrollbar-width: 10px`
- `styles/panel.css` - Scrollbar vertical tabla Anuncios + overflow-x: hidden
- `styles/progress-tab.css` - Scrollbar vertical mejorado

---

## v10.5.143 - Feature: Desplegable cuentas tiempo real (2025-11-29)

### ✨ Nuevas funcionalidades

**Pendientes de publicar en tiempo real**
- El desplegable de cuentas se actualiza automáticamente via WebSocket
- Muestra `josel ⏳5` cuando hay pendientes
- Cambia a `josel (154)` cuando ya no hay
- Sin necesidad de recargar la página

**Eventos implementados:**
- `ACCOUNT.PENDING_UPDATED` - Backend emite cuando cambia publish_status
- Se emite en: start, cancel, update-status

### Backend v2.9.41:
- Nueva función `emit_account_pending_updated()` en websocket_events.py
- Emite evento en publish_simple.py: start, cancel, update-status
- Campo `pending_publish_count` en endpoints /accounts y /panel/init

### Archivos modificados:
- Backend `websocket_events.py` - emit_account_pending_updated()
- Backend `publish_simple.py` - Emite evento en start/cancel/update-status
- Backend `main.py` - Campo pending_publish_count en /api/walla/accounts
- `scripts/panel/listeners.js` - Handler ACCOUNT.PENDING_UPDATED

---

## v10.5.142 - Fix: Scroll infinito + Pendientes en desplegable (2025-11-29)

### 🔧 Correcciones

**Scroll infinito + Seleccionar todos**
- Cuando "Seleccionar todos" está activo y se hace scroll
- Las nuevas filas cargadas se añaden automáticamente a la selección
- Se marcan tanto el checkbox como el background verde

### ✨ Nuevas funcionalidades

**Pendientes de publicar en desplegable de cuentas**
- Si hay anuncios pendientes, muestra: `josel ⏳5`
- Si no hay pendientes, muestra el formato anterior: `josel (154)`
- Backend v2.9.41 añade campo `pending_publish_count`

**Badges categoría más transparentes**
- Background reducido a `rgba(..., 0.25)`
- Color más sutil, casi transparente

### Archivos modificados:
- `scripts/panel/listings/progressive.js` - Auto-selección en loadMoreItems()
- `scripts/panel/ui.js` - Pendientes en desplegable
- `styles/panel.css` - Badges con opacity 0.25
- Backend `panel_init.py` - Campo pending_publish_count

---

## v10.5.141 - Fix: Sincronización visual selección + Scroll infinito (2025-11-28)

### 🔧 Correcciones

**Sincronización background selección**
- Nueva función `syncRowSelectionVisuals()` centralizada
- Se llama después de:
  - Seleccionar/deseleccionar todos
  - Añadir nuevas filas (scroll infinito)
  - Cambiar de filtro
- Garantiza que clase `.selected` siempre coincide con estado lógico

**Badges categoría - Mejor contraste**
- Fondo con opacity 0.6 (más suave)
- Texto con `text-shadow` para legibilidad
- `font-weight: semibold` para destacar

### Archivos modificados:
- `scripts/panel/listings/events.js` - syncRowSelectionVisuals(), attachCheckboxEvents()
- `styles/panel.css` - Estilos categoría con rgba()

---

## v10.5.140 - UX: Selección mejorada + Estilos refinados (2025-11-28)

### ✨ Nuevas funcionalidades

**1. Click en fila para seleccionar**
- Click simple en cualquier parte de la fila = toggle selección
- Excepciones: imagen (zoom), checkbox (ya funciona), input inventario
- Doble-click sigue abriendo editor

**2. Background seleccionado VERDE llamativo**
- Cambio de azul a verde (`--success-bg`)
- Barra lateral verde intensa
- Animación de pulso más visible al seleccionar
- Distinto al hover (azul)

**3. Checkbox "Seleccionar todos" diferenciado**
- Borde verde destacado (`outline: 2px solid`)
- Crece al hover (scale 1.15)
- Color naranja cuando hay selección parcial (indeterminate)
- Tooltip mejorado: "☑️ Seleccionar/Deseleccionar TODOS"

**4. X del buscador más visible**
- Color rojo (`#ef4444`)
- Tamaño aumentado (18px)
- Efecto scale al hover

**5. Badges categoría más suaves**
- Añadido `opacity: 0.75` para reducir intensidad

**6. Separadores cabecera más visibles**
- Cambiado a `2px solid --brand-overlay-medium`

### Archivos modificados:
- `panel.html` - Tooltip mejorado
- `styles/panel.css` - Estilos selección, X buscador, categorías, cabecera
- `scripts/panel/listings/events.js` - setupRowClickToSelect()

---

## v10.5.139 - UX: Mejoras visuales tabla + Ordenar título + Búsqueda fix (2025-11-28)

### 🔧 Correcciones

**Búsqueda mejorada (Backend v2.9.40)**
- Usa `LOWER()` explícito para garantizar case-insensitive
- Añadida búsqueda en categoría
- Ahora busca en 5 campos: título, descripción, ID, inventario, **categoría**

### ✨ Nuevas funcionalidades

**1. Ordenar por título**
- Click en cabecera "Título" para ordenar A-Z / Z-A
- Persiste en localStorage

**2. Cabecera con divisiones visibles**
- Líneas verticales entre columnas (`border-right`)
- Mejor separación visual

**3. Cebrado más contrastado**
- Filas pares: `--bg-tertiary` (más claro)
- Filas impares: `--bg-primary` (más oscuro)

**4. Botones Publicar/Reanudar EXTREMOS**
- Scale hasta 1.15 (antes 1.02)
- Sombra glow más intensa
- Animación más rápida (1.5s)
- `transform-origin: center` para no desplazar

**5. Categorías con colores**
- 8 colores automáticos basados en hash del nombre
- Badges redondeados con fondo de color
- Texto más grande (`--text-sm`)
- Tooltip con nombre completo

### Variables CSS añadidas
```css
--cat-color-1 a --cat-color-8  /* Paleta de categorías */
```

### Archivos modificados:
- `panel.html` - Título sortable
- `styles/variables.css` - Colores de categoría
- `styles/panel.css` - Cabecera, cebrado, botones, categorías
- `scripts/panel/listings/render.js` - getCategoryColor()
- `scripts/panel/listings/events.js` - Ordenación título
- Backend `walla_runs.py` - Búsqueda con LOWER() y categoría

---

## v10.5.138 - Feature: Columna Categoría ordenable (2025-11-28)

### ✨ Nuevas funcionalidades

**Columna Categoría (reemplaza ID de Wallapop)**
- Muestra la categoría más específica del anuncio (última del array taxonomy)
- Ordenable (asc/desc) como precio y fecha
- Truncada a 20 caracteres con tooltip completo
- Resaltado de búsqueda funciona también aquí

### Backend v2.9.39
- Nuevo campo `category` en respuesta de listings
- Extrae automáticamente el último elemento de `$.taxonomy[].name`
- Soporta ordenación `category_asc` y `category_desc`

### Cambios
- `col-id` → `col-category` en HTML y CSS
- `data-category` añadido a cada fila para ordenación local
- `updateSortHeaderUI()` actualizado para 3 columnas

### Archivos modificados:
- `panel.html` - Nueva cabecera Categoría
- `styles/panel.css` - Estilos col-category
- `scripts/panel/listings/render.js` - Renderiza categoría
- `scripts/panel/listings/events.js` - Ordenación por categoría
- Backend `walla_runs.py` - Extracción y ordenación

---

## v10.5.137 - Feature: Ordenar por precio + Indicador posición scroll (2025-11-28)

### ✨ Nuevas funcionalidades

**1. Ordenar por precio**
- Click en cabecera "Precio" para ordenar asc/desc
- Indicador visual de dirección (↑/↓)
- Persiste en localStorage
- Compatible con scroll infinito

**2. Indicador de posición en scroll**
- El contador muestra rango visible: "25-50 de 157"
- Se actualiza dinámicamente al hacer scroll
- Ayuda a saber en qué parte de la lista estás

### Refactorización de ordenación
- `setupSortingListeners()` ahora soporta múltiples columnas
- Nueva función `handleSortClick()` - lógica compartida
- Nueva función `updateSortHeaderUI()` - actualiza todos los headers

### Archivos modificados:
- `panel.html` - Cabecera precio con sortable
- `styles/panel.css` - Estilos para col-price sortable
- `scripts/panel/listings/events.js` - Lógica de ordenación multi-columna
- `scripts/panel/listings/progressive.js` - Indicador posición scroll

---

## v10.5.136 - UI: Resaltado búsqueda, fechas colores, pulso botones (2025-11-28)

### ✨ Nuevas funcionalidades

**1. Resaltado de coincidencias en búsqueda**
- Las palabras buscadas se resaltan en amarillo en título e ID
- Funciona con múltiples palabras (cada una se resalta)
- Nuevas variables CSS: `--highlight-bg`, `--highlight-text`

**2. Fechas de publicación con colores**
- 🟢 Verde (`date-today`): Publicado hoy
- 🟡 Amarillo (`date-recent`): Publicado hace 1-3 días  
- ⚪ Gris (`date-old`): Más antiguo
- Fuente más grande y con badge de color

**3. Efecto pulso en botones Publicar/Reanudar**
- Animación de latido cuando están visibles
- Llama la atención del usuario para actuar
- Se detiene al hacer hover

**4. Filtro TOTAL eliminado**
- Solo quedan: Activos, Destacados, Reservados, Eliminados
- Simplifica la UI

**5. Mejor contraste en cebrado de tabla**
- Filas pares: `--overlay-medium` (antes `--overlay-light`)
- Filas impares: `--bg-secondary` (antes `transparent`)

### Variables CSS añadidas (variables.css)
```css
/* Fechas */
--date-today, --date-today-bg
--date-recent, --date-recent-bg  
--date-old, --date-old-bg

/* Resaltado búsqueda */
--highlight-bg, --highlight-text
```

### Archivos modificados:
- `styles/variables.css` - Nuevas variables
- `styles/panel.css` - Estilos de fecha, resaltado, pulso, cebrado
- `scripts/panel/listings/render.js` - Lógica de resaltado y fechas
- `panel.html` - Eliminado filtro TOTAL

---

## v10.5.135 - Fix: Botón Sincronizar tamaño fijo + Buscador multi-palabra (2025-11-28)

### 🐛 Bug fixes

**Problema: Botón Sincronizar se expandía al mostrar más botones**
- El layout flexbox distribuía espacio extra hacia los botones
- El `width: auto` permitía que el botón creciera

**Solución CSS:**
- `.btn-sync`: Cambiado a `flex: 0 0 auto` + `max-width: fit-content`
- `.selection-info`: Cambiado a `display: inline-flex` + `max-width: fit-content`
- `.search-input`: Ajustado flex y max-width para dar espacio

### 🔍 Mejoras en Buscador (Backend v2.9.38)

**Problema:** La búsqueda "maceta bello" no encontraba "Maceta 1kg BELLOTA"
- Buscaba la cadena completa "%maceta bello%" que no existía

**Solución:**
- Divide el texto de búsqueda por espacios
- Busca cada palabra individualmente con AND
- Ejemplo: "maceta bello" → busca "%maceta%" AND "%bello%"
- Busca en: título, descripción, id_wallapop, inventory_note
- Case-insensitive (MariaDB collation utf8_general_ci)

### Archivos modificados:
- `styles/panel.css` - Layout fijo para botones
- Backend `walla_runs.py` - Búsqueda multi-palabra

---

## v10.5.134 - Fix: Layout botón Sincronizar + Buscador mejorado (2025-11-28)

### 🐛 Bug fixes

**Problema: Botón Sincronizar se expandía al mostrar botones de selección**
- Cuando aparecían botones Publicar/Eliminar/Reanudar/Cancelar, el botón Sincronizar crecía
- El layout flexbox distribuía espacio extra hacia `.selection-info`

**Solución:**
- `.ml-listings-controls`: Añadido `justify-content: flex-start` para evitar distribución
- `.search-input`: Cambiado a `flex: 1 1 200px` para absorber espacio sobrante
- `.selection-info`: Consolidado a `flex: 0 0 auto` (completamente rígido)

### 🔍 Mejoras en Buscador

- Placeholder descriptivo: "🔍 Buscar título, ID, inventario..."
- Tooltip explicativo sobre qué campos busca
- Normalización del texto (trim) antes de enviar al backend
- Min-width reducido a 150px para mejor responsive

### Archivos modificados:
- `styles/panel.css` - Layout corregido
- `panel.html` - Placeholder y tooltip mejorados  
- `scripts/panel/listings/events.js` - Normalización de búsqueda

---

## v10.5.82 - Fix: UI estable durante publicación + Botón Sincronizar (2025-11-28)

### 🐛 Bug fixes

**Problema 1: Contenedor fijo de procesamiento desaparecía al cambiar de tab**
- El contenedor `progress-processing-fixed` solo se actualizaba si el tab "En Curso" estaba activo
- Al cambiar de pestaña y volver, a veces no aparecía
- Parpadeo visible cuando cambiaba de anuncio (re-render completo)

**Solución:**
- Nueva función `renderProcessingFixed()` que se ejecuta SIEMPRE, independiente del tab activo
- Transición suave (fade 150ms) al cambiar de anuncio en vez de parpadeo
- Actualización quirúrgica del DOM (solo si el contenido cambió)
- Tracking con `STATE._lastProcessingId` para detectar cambio de anuncio

**Problema 2: Botones Reanudar/Cancelar desaparecían durante publicación activa**
- Los botones dependían de `current_item.status === 'processing'`
- En momentos de transición entre anuncios, `current_item` podía ser null/undefined
- Esto causaba que `processingCount = 0` y los botones aparecían brevemente

**Solución:**
- Cambio de lógica: `processingCount = (processed < total) ? 1 : 0`
- Mientras queden anuncios por procesar, la publicación está activa
- Ya no depende del estado transitorio del `current_item`

**Problema 3: TypeError logger.log is not a function**
- `auth.js` usaba `logger.log()` que no existe en la clase Logger
- Corregido a `logger.info()`

### 🎨 UI: Botón "Sincronizar" (antes "Backup")

**Cambios visuales:**
- Renombrado de "Backup" a "Sincronizar" con icono 🔄
- Botón diferenciado visualmente (azul info vs los demás)
- Fecha/hora prominente con fondo oscuro semitransparente
- Formato mejorado: "28/11 14:30" con tooltip completo

**Responsive:**
- Pantallas grandes: 🔄 Sincronizar 28/11 14:30
- Pantallas medianas (<600px): 🔄 28/11 14:30 (sin texto)
- Pantallas pequeñas (<420px): Solo 🔄 (fecha en tooltip)

### Flujo actualizado:
```
WebSocket → publish_progress
           ├── processingCount = (processed < total) ? 1 : 0  ← NUEVO
           └── handleProgressUpdate()
               ├── renderProcessingFixed() ← SIEMPRE se ejecuta
               ├── renderItemsListOnly()   ← Solo si tab activo
               └── updateBadge()           ← Siempre
```

### Archivos modificados:
- `panel.html`: Botón con nueva estructura (.btn-sync, .btn-sync-datetime)
- `panel.js`: Lógica de `processingCount` + formato fecha mejorado
- `panel.css`: Nuevos estilos .btn-sync con responsive
- `progress-tab.js`: Nuevas funciones de renderizado independiente
- `progress-tab.css`: Clase `.transitioning` para transiciones suaves
- `runs.js`: Formato de fecha/hora mejorado

---

## v10.5.81 - Anti-abuso: Bloqueo de cuentas Wallapop duplicadas (2025-11-27)

### 🔒 Seguridad

**Problema:** Usuarios podían crear múltiples cuentas de Google, obtener créditos de cortesía cada vez, y vincular la misma cuenta de Wallapop para usar esos créditos gratis.

**Solución v10.5.81:**
- Backend verifica si la cuenta Wallapop ya existe en otro usuario
- Si existe en usuario normal → Error 409 con mensaje informativo
- Si existe en admin → Permitir (gestión delegada)
- Extensión muestra modal explicativo al usuario afectado

### Mensaje al usuario:
> "Esta cuenta de Wallapop ya está vinculada a otro usuario. Si eres el propietario legítimo y perdiste acceso a tu cuenta anterior, contacta con soporte."

### 🐛 Bug fix

**Problema:** El campo `users.extension_version` nunca se actualizaba porque `updateExtensionVersion()` estaba importada pero nunca se llamaba.

**Solución:** Añadida llamada a `updateExtensionVersion()` en `initPanel()` cuando el usuario está autenticado.

### Archivos modificados:
**Backend:**
- `accounts.py`: Nueva excepción `DuplicateAccountError` + verificación anti-abuso
- `main.py`: Verificación en endpoint `/api/walla/accounts`
- `router.py`: Manejo de excepción en `import_listings`
- `run_engine.py`: Import de la excepción

**Extensión:**
- `panel.js`: Mostrar modal en errores de backup + llamar `updateExtensionVersion()`
- `auth.js`: Mostrar modal en creación de cuenta
- `resume.js`: Mostrar modal en reanudación

---

## v10.5.63 - Errores recuperables continúan automáticamente (2025-11-26)

### 🐛 Bug fix

**Problema:** Cuando el token expiraba:
1. Se marcaba el anuncio como `error_retry` ✓
2. Pero el proceso se **detenía completamente** (break)
3. El usuario tenía que reanudar manualmente

**Solución v10.5.63:**
1. Si el error es **recuperable** (token expirado) → `continue` con siguiente anuncio
2. El siguiente anuncio navega a `/upload` limpio
3. Wallapop genera token nuevo automáticamente
4. Los `error_retry` se reintentan al final del ciclo

### Errores recuperables (continúan automáticamente):
- "No se pudieron obtener credenciales de Wallapop"
- "token_expired"
- "Token expirado"

### Errores fatales (detienen proceso):
- "wallapop_session_expired" (requiere re-login)

### Flujo ahora:
```
Anuncio #13: Token expira → error_retry → continue
Anuncio #14: Navega a /upload → Token nuevo → ✅ Publicado
...
Final del ciclo: Reintentar #13 → ✅ Publicado
```

### Archivos modificados:
- `panel.js`: Detectar errores recuperables y continuar
- `sw/walla.js`: Retornar código específico para token expirado

---

## v10.5.62 - Fix crítico: No borrar token durante refresh (2025-11-26)

### 🐛 Bug fix CRÍTICO

**Problema:** Cuando intentábamos refrescar el token:
1. Borrábamos el token actual ANTES de tener uno nuevo
2. Esperábamos 5s a capturar uno nuevo
3. Si no llegaba (Wallapop no hace peticiones en /upload), nos quedábamos SIN TOKEN
4. Error: "No se pudieron obtener credenciales"
5. El token nuevo llegaba DESPUÉS del error (tarde)

**Solución v10.5.62:**
1. **NO borramos** el token actual hasta tener uno nuevo
2. Si el refresh falla pero el token actual aún tiene tiempo → **lo usamos**
3. Buffer aumentado de 30s a **45s** para dar más margen
4. Solo fallamos si el token actual YA expiró

### Logs ahora:
```
Restante: 40s | ¿Refrescar?: true
[TOKEN] 🔄 Token por expirar (<45s), intentando refrescar...
[TOKEN] ⚠️ Refresh falló, usando token actual (restante: 35s)  ← Continúa!
```

### Archivos modificados:
- `sw/walla.js`: Lógica de fallback en `refreshWallaCredsIfOld()`

---

## v10.5.61 - Fix refresh innecesario de token (2025-11-26)

### 🐛 Bug fix

**Problema:** El sistema intentaba refrescar el token cuando tenía >90s de edad, pero el token de Wallapop dura ~5 minutos. Esto causaba:
- Intentos de refresh innecesarios (capturaba el mismo token)
- Delays de 5s esperando un token que ya teníamos
- Comportamiento errático en la UI (modal aparece/desaparece)

**Solución:** Solo refrescar cuando:
1. No hay token
2. Token ya expiró
3. Quedan <30s para expirar
4. Forzado después de un 401

### Logs ahora:
```
Real: 2m 30s | Restante: 2m 30s | ¿Refrescar?: false  ← NO refresca
Real: 4m 45s | Restante: 15s | ¿Refrescar?: true      ← SÍ refresca
```

### Archivos modificados:
- `sw/walla.js`: Lógica simplificada en `refreshWallaCredsIfOld()`

---

## v10.5.60 - Edad REAL del token JWT (2025-11-26)

### ✨ Mejora crítica de diagnóstico

**Problema identificado:** Medíamos la edad del token desde cuándo lo CAPTURAMOS, no desde cuándo WALLAPOP lo generó.

**Solución:** Decodificar el JWT y extraer los campos `iat` (issued at) y `exp` (expiration):

```
Antes: "Token edad: 2s" → Capturado hace 2s (puede tener 1m 50s de vida real)
Ahora: "Real: 1m 52s | Restante: 8s" → Edad y expiración REALES
```

### Cambios en logs:
```
[TOKEN] 🔄 NUEVO token! (eyJhbG...) | Expira: 17:15:30 | Restante: 2m 0s
[TOKEN] 📊 ANTES de DELETE: Real: 45s | Restante: 1m 15s
[TOKEN] 🔍 Verificando: Real: 1m 30s | Restante: 30s | ¿Refrescar?: true
```

### Cambios en lógica:
- `refreshWallaCredsIfOld()` ahora usa edad REAL del JWT
- Refresca si: edad real > límite O tiempo restante < 30s

### Archivos modificados:
- `sw/walla.js`: Nueva función `decodeJWT()`, `getTokenRealAge()`, logs mejorados
- `sw/handlers/publish-process-next.js`: Logs actualizados con edad real

---

## v10.5.59 - Detección de sesión expirada de Wallapop (2025-11-26)

### ✨ Nueva funcionalidad

**Detección clara de sesión expirada** cuando Wallapop cierra la sesión después de muchas publicaciones.

Cuando ocurre:
- Toast: "🔒 Wallapop cerró tu sesión. Vuelve a iniciar sesión en Wallapop."
- Alerta con instrucciones claras para el usuario

### Archivos modificados:
- `content_script.js`: Nuevo código `wallapop_session_expired` cuando fallan reintentos por error de servidor
- `panel.js`: Detección del código y mensaje claro al usuario

### Eliminado:
- Keepalive de sesión Wallapop (no resolvía el problema real)

---

## v10.5.56 - Fix loop infinito en token refresh (2025-11-26)

### 🐛 Bug corregido

**Error:** Loop infinito de refresh cuando `maxAgeMs = 0`

**Causa:** La condición `age.ms > 0` siempre es true, causando refreshes infinitos.

```
Token capturado → edad 1ms → 1ms > 0 = true → "viejo" → refresh → loop
```

**Fix:** Nuevo parámetro booleano `forceRefresh` en lugar de usar `0` como valor mágico.

### Archivos modificados:
- `sw/walla.js`: Añadido parámetro `forceRefresh` a `refreshWallaCredsIfOld()`
- `service_worker.js`: Cambiado `refreshWallaCredsIfOld(tabId, 0)` → `refreshWallaCredsIfOld(tabId, 90000, true)`
- `sw/handlers/publish-process-next.js`: Igual

---

## v10.5.55 - Fix imports dinámicos en realtime.js (2025-11-26)

### 🐛 Bug corregido

**Error:** `import() is disallowed on ServiceWorkerGlobalScope` en `sw/realtime.js`

**Causa:** 5 imports dinámicos (`await import()`) en archivo SW violaban REGLA #50 de MV3.

**Fix:** Convertidos a imports estáticos según guía:

```javascript
// ANTES (❌ violaba MV3)
const { doRefresh } = await import('./api_client.js');
const { stopAutoRefresh } = await import('./token_refresher.js');

// DESPUÉS (✅ MV3 compliant)
import { doRefresh, session, isAccessNearExpiry, setAuthState, AUTH_STATES } from './api_client.js';
import { stopAutoRefresh } from './token_refresher.js';
import { stRemove } from './storage.js';
```

### Archivo modificado:
- `sw/realtime.js`: 5 imports dinámicos → estáticos

---

## v10.5.54 - Reintento con token fresco en 401 (2025-01-24)

### 🔧 Corrección crítica

**Problema:** Cuando Wallapop invalida el token server-side, las operaciones fallaban 4 veces con el mismo token inválido.

**Solución:** Reintento automático con token fresco cuando se detecta 401.

### DELETE (en SW):
```
Token fresco → DELETE → ¿401? → Refresh token → Reintentar 1 vez
```

### PUBLICAR (en CS):
```
Token fresco → Click → ¿Error servidor? → Pedir refresh al SW → Reintentar
```

### 🐛 Bug corregido

**Error:** `import() is disallowed on ServiceWorkerGlobalScope`

**Causa:** Import dinámico en SW no permitido en MV3.

**Fix:** Cambiado a import estático de `refreshWallaCredsIfOld`.

### Cambios técnicos:

- `service_worker.js`: Import estático de `refreshWallaCredsIfOld` + handler `TOKEN.FORCE_REFRESH`
- `publish-process-next.js`: DELETE con reintento en 401
- `content_script.js`: Envía `TOKEN.FORCE_REFRESH` al SW antes de reintentar
- `progress-tab.js`: Fix contador de tiempo (solo resetea si cambia mensaje)

---

## v10.5.53 - Mensajes dinámicos de paso (2025-01-24)

### ✨ Nueva funcionalidad

**Mensajes dinámicos en item procesando:**
- Muestra en tiempo real qué paso se está ejecutando
- Sin tráfico de red (comunicación local en extensión)
- Sin impacto en rendimiento (~0.1ms por mensaje)

**Mejoras visuales:**
- ⟳ **Spinner CSS giratorio** en lugar de emoji
- ⏱️ **Tiempo transcurrido** por paso (ej: "Rellenando... (8s)")
- 🎨 **Color progresivo** según avance:
  - Pasos 1-2 (inicio): Azul
  - Pasos 3-4 (medio): Naranja  
  - Pasos 5-7 (final): Verde

**Pasos mostrados:**
1. Esperando formulario...
2. Seleccionando categoría...
3. Subiendo imágenes...
4. Rellenando formulario...
5. Verificando...
6. Eliminando anuncio viejo...
7. Publicando...

### 🔧 Implementación

**Flujo de datos (100% local):**
```
publish-process-next.js → sendStepMessage(msg, step)
        ↓
chrome.runtime.sendMessage
        ↓
panel.js → PUBLISH.STEP_MESSAGE
        ↓
ProgressTab.updateStepMessage() → DOM
```

**CSS (REGLA #2):**
```css
.progress-item-step[data-step="1"] { color: var(--brand-secondary); }
.progress-item-step[data-step="4"] { color: var(--warning-400); }
.progress-item-step[data-step="7"] { color: var(--success-300); }
```

---

## v10.5.52 - Rediseño filtros pestaña "En Curso" (2025-01-24)

### 🔄 Cambios principales

**Filtros rediseñados:**
- Eliminado filtro "Procesados" - Ahora solo: Exitosos, Errores, Pendientes
- Grid de 3 columnas en vez de 4
- Filtro por defecto: Pendientes

**Item "Procesando" siempre visible:**
- Nuevo contenedor fijo arriba (`progress-processing-fixed`)
- Borde amarillo/naranja para destacar
- Visible independientemente del filtro seleccionado

**Estados corregidos:**
- `pending` / `queued_publish` → "Pendiente" (naranja)
- `published` / `success` → "Exitoso" (verde)  
- `error_retry` → "Error" (rojo)
- Ya no muestra "Desconocido"

### 🧹 Limpieza de código (siguiendo Guía)

- Eliminado código muerto (~100 líneas) de renderItemsList
- Eliminadas constantes no usadas: `MAX_SUCCESS_SHOWN`, `MAX_ERRORS_SHOWN`
- Eliminada duplicación de `ITEMS_PER_PAGE`
- Cada case del switch ahora tiene return explícito

### 🎨 CSS mejorado (REGLA #2)

```css
/* Colores de status usando variables */
.progress-item-status.pending { color: var(--warning-500); }
.progress-item-status.success { color: var(--success-500); }
.progress-item-status.error { color: var(--error-500); }
```

---

## v10.5.51 - UI refinada y bug filtros (2025-01-24)

### 🐛 Bug crítico corregido

**Filtro se reseteaba al procesar anuncios:**
- `switchAccount()` se llamaba constantemente desde `loadAccountState()`
- Ahora detecta si es la misma cuenta y preserva el filtro seleccionado

### 🎨 Botones rediseñados (REGLA #2 compliant)

**Antes:** Botones grandes con animación pulse molesta
**Ahora:** Compactos, discretos, sin animaciones invasivas

```css
/* Usando variables CSS según REGLA #2 */
font-size: var(--text-xs);
padding: var(--space-1) var(--space-2);
box-shadow: 0 var(--space-1) var(--space-2) var(--success-border);
```

### 📝 Mensaje informativo en errores

Cuando hay errores, se muestra un banner:
> "🔄 X anuncios con errores - Estos anuncios se reintentarán automáticamente al finalizar el ciclo."

### 🔧 CSS mejorado (REGLA #2)

- Todos los valores usan variables CSS
- `.selection-info` usa `flex-wrap: wrap` (sin scroll)
- Estilos `.progress-info-notice-error` con `var(--error-bg)`

---

## v10.5.50 - Fix críticos pestaña "En Curso" (2025-01-24)

### 🐛 Bugs corregidos

**Anuncios exitosos mostraban como error:**
- Backend devuelve `published`, frontend esperaba `success`
- Ahora normaliza el status en filtros, conteos y renderizado

**Filtros no se mantenían visualmente:**
- Añadida función `applyFilterVisual()` que se ejecuta en cada render

**Scroll feo en barra de acciones:**
- Cambiado `overflow-x: auto` → `flex-wrap: wrap` en `.selection-info`

### 🗑️ Eliminado

- Toast "¡Vuelve a la pestaña de Wallapop!" (molesto, innecesario)
- Toast "✅ Publicación en curso" (redundante)

### 📊 Mapeo de estados corregido

```
Backend → Frontend → CSS
published → Exitoso → .success (verde)
success → Exitoso → .success (verde)
error_retry → Error → .error (rojo)
processing → Procesando → .processing (amarillo)
pending → Pendiente → .pending (gris)
```

---

## v10.5.49 - Mejoras UI pestaña "En Curso" (2025-01-24)

### 🎨 Cambios en UI

**Eliminado:**
- Stats de Tiempo, Velocidad y Restante (innecesarios)
- Toast "✓ Procesado x..." (progreso visible en pestaña)

**Mejorado:**
- Slider de delay más grande y fácil de usar (300px max, thumb 20px)
- Filtros de stats ahora mantienen estado visual al renderizar
- Clase CSS corregida para items con error (error_retry → error)

### 📊 Filtros que funcionan

```
PROCESADOS  EXITOSOS  ERRORES  PENDIENTES
   [27]       [27]      [5]      [148]
     ↑
   active (borde azul, elevado, glow)
```

Al hacer click en un stat, se resalta visualmente y filtra la lista.

---

## v10.5.48 - Fix combos Brand/Model cuando están vacíos (2025-01-24)

### 🐛 Bug fix: Combos sin pre-selección

**Problema:** Si Wallapop no pre-seleccionaba valor en Brand/Model (combo muestra "Marca*" vacío), fallaba porque `focus()` no forzaba la carga AJAX de opciones.

**Solución:** Añadir `click()` SOLO cuando el combo está vacío:

```javascript
if (!valorActual.trim()) {
  brandInput.click(); // Solo si vacío
}
```

| Caso | Acción |
|------|--------|
| Combo vacío ("Marca*") | `click()` + `focus()` |
| Combo con valor (pre-seleccionado) | Solo `focus()` (lógica existente) |

La lógica existente para limpiar valores incorrectos pre-seleccionados sigue intacta.

---

## v10.5.47 - Refresh automático de token antes de DELETE y PUBLICAR (2025-01-24)

### 🔄 Token de Wallapop siempre fresco

**Problema:** El token de Wallapop expira en ~2 minutos. Si el usuario configura delays largos (10 min, 1 hora), el token podría expirar antes de DELETE o PUBLICAR.

**Solución:**

1. **Nueva función `refreshWallaCredsIfOld(tabId, maxAgeMs)`** en walla.js:
   - Verifica si el token tiene más de 90 segundos
   - Si es viejo: invalida, fuerza captura con FORCE_REFRESH, espera token nuevo
   - Logging detallado del proceso

2. **Nuevo mensaje `CAPTURE.FORCE_REFRESH`** en content_script.js:
   - Hace scroll en la página (puede triggear lazy loading)
   - Hace fetch a `/api/v3/general/categories` (genera tráfico)
   - El interceptor captura cualquier token nuevo

3. **Se usa antes de cada acción crítica:**
   - Antes de DELETE del anuncio viejo
   - Antes de CLICK en publicar

### 📊 Logs que verás

```
[TOKEN] 🔍 Verificando edad: 1m 45s | Límite: 90s | ¿Viejo?: true
[TOKEN] 🔄 Token viejo, intentando refrescar...
[ML] 🔄 CAPTURE.FORCE_REFRESH ejecutado
[TOKEN] ✅ Token refrescado! Nueva edad: 0s
[TOKEN] 🔄 Token REFRESCADO antes de DELETE!
```

---

## v10.5.46 - Diagnóstico de token Wallapop (2025-01-24)

### 🔍 Logging de diagnóstico añadido

Para investigar si los errores son por **token expirado** o **rate limiting**:

**En walla.js:**
- `getTokenAge()` - Calcula la edad del token en formato legible
- `getTokenDiagnostics()` - Info completa: hasToken, edad, capturedAt
- Log cuando se captura token nuevo
- Log cuando se carga token de storage

**En publish-process-next.js:**
- Log ANTES de DELETE con edad del token y anuncios procesados
- Log DESPUÉS de DELETE con resultado HTTP y edad del token
- Log de progreso: "Anuncio #N publicado | Tiempo ciclo | Token edad"
- Timestamp de inicio del ciclo de publicación

**En content_script.js:**
- Log con hora exacta cuando se detecta "error servidor"
- Tiempo transcurrido desde click hasta error

### 📊 Ejemplo de logs

```
[TOKEN] 📊 ANTES de DELETE #5: { edad: "1m 45s", token: "eyJhbG...", anunciosProcesados: 5 }
[TOKEN] 📊 DELETE resultado: HTTP 401 | Token edad: 1m 45s | Anuncios: 5
[TOKEN] ⚠️ DELETE 401 - Token probablemente expirado. Edad: 1m 45s
[PUBLISH] ✅ Anuncio #5 publicado | Tiempo ciclo: 180s | Token edad: 1m 45s
[ML] ⚠️ ERROR SERVIDOR detectado después de 3s
```

---

## v10.5.45 - Reintento automático por error de servidor (2025-01-24)

### 🔄 Detección y reintento de "error en el servidor"

- Detecta toast de Wallapop con "error" + "servidor/server"
- Reintenta hasta 3 veces con espera de 15s entre intentos
- Log detallado cuando se detecta error

---

## v7.0.0 - LIMPIEZA: Eliminación completa de modal deprecada (2025-11-19)

### 🧹 Breaking Change - Código legacy eliminado

**ANTES (v6.12.0):** Modal y Tab coexistían (código deprecado marcado)
**AHORA (v7.0.0):** Solo Tab "En Curso" (código limpio)

### ❌ Archivos eliminados

1. **scripts/panel/publishing-monitor.js** (~1200 líneas)
   - Toda la lógica de modal flotante
   - Minimizar/maximizar
   - Overlay/backdrop
   - Badge en footer

2. **styles/publishing-monitor.css** (~600 líneas)
   - Estilos de modal
   - Animaciones de overlay
   - Estados hover/active

### 🔧 Código eliminado

**En panel.js:**
- ❌ Import de PublishingMonitor
- ❌ `PublishingMonitor.startMonitor()`
- ❌ `PublishingMonitor.updateProgress()`
- ❌ `PublishingMonitor.updateItem()`
- ❌ `PublishingMonitor.initMonitor()`
- ❌ `PublishingMonitor.getState()`
- ❌ `PublishingMonitor.showIfSameAccount()`
- ❌ `PublishingMonitor.hideIfDifferentAccount()`

**En listeners.js:**
- ❌ `PublishingMonitor.forceClose()`

**En panel.html:**
- ❌ Link a publishing-monitor.css
- ❌ HTML de modal (ya no existía en v6.12.0)

### ✅ Código mantenido (limpio)

**En panel.js:**
- ✅ `ProgressTab.startPublication()`
- ✅ `ProgressTab.handleProgressUpdate()`
- ✅ `ProgressTab.switchAccount()`
- ✅ `ProgressTab.finishPublication()`

**En listeners.js:**
- ✅ `ProgressTab.clear()`

**En tabs.js:**
- ✅ `ProgressTab.init()`

### 📊 Impacto

| Métrica | v6.12.0 | v7.0.0 | Mejora |
|---------|---------|--------|---------|
| Archivos JS | 2 (modal + tab) | 1 (tab) | -50% |
| Líneas código | ~1600 | ~400 | -75% |
| Referencias deprecadas | 8 | 0 | -100% |
| Complejidad | Media | Baja | +60% |

### ⚠️ Migración

**No requiere acción del usuario:**
- Si usabas v6.11.x o anterior → Actualizar a v7.0.0 directamente
- Si usabas v6.12.0 → Actualizar a v7.0.0 (sin cambios visibles)

**Cambios visibles:**
- Ninguno - La UX es idéntica a v6.12.0
- Solo se eliminó código deprecado interno

### 🎯 Beneficios

1. **Código más limpio**
   - Sin referencias deprecadas
   - Sin comentarios "TODO: eliminar en v7.0"
   - Sin código muerto

2. **Más fácil de mantener**
   - Una sola forma de mostrar progreso (Tab)
   - Menos archivos que modificar
   - Menos bugs potenciales

3. **Mejor rendimiento**
   - Menos código cargado
   - Menos memoria usada
   - Menos archivos parseados

4. **Arquitectura clara**
   - Tab "En Curso" es la única forma
   - No hay confusión modal vs tab
   - Código futuro más simple

---

## v6.12.0 - MIGRACIÓN: Modal → Tab "En Curso" (2025-11-19)

### 🎯 Cambio arquitectónico mayor

**ANTES:** Modal flotante que aparece/desaparece automáticamente
**AHORA:** Tab "En Curso" integrado en el panel (como Anuncios, Actividad, Config)

### ✅ Ventajas de la migración

1. **Simplicidad:**
   - Eliminada toda la lógica de minimizar/maximizar
   - Eliminada lógica de sincronización de estados
   - ~500 líneas de código complejo removidas
   - Código más limpio y mantenible

2. **UX más predecible:**
   - Usuario sabe dónde buscar (siempre en las tabs)
   - No hay "sorpresas" de modales apareciendo
   - Consistente con el resto del panel

3. **Performance:**
   - No hay overlay bloqueando UI
   - Renderiza solo cuando tab está activo
   - Badge actualizado en tiempo real (mínimo impacto)

4. **Multi-cuenta mejorada:**
   - Tab se oculta/muestra según cuenta activa
   - Cada cuenta tiene su propio estado
   - Todo persistente en BD (0% localStorage)

### 🔧 Implementación

**Nuevos archivos:**
- `scripts/panel/progress-tab.js` - Lógica del tab
- `styles/progress-tab.css` - Estilos (reutilizando variables)

**Archivos modificados:**
- `panel.html` - Añadido tab-button y tab-panel
- `scripts/panel/tabs.js` - Soporte para 'in_progress'
- `panel.js` - Integración con WebSocket
- `scripts/panel/listeners.js` - Clear al logout

**Archivos DEPRECADOS (se eliminarán en v7.0):**
- `scripts/panel/publishing-monitor.js` - Modal antigua
- Parte de `styles/publishing-monitor.css` - Estilos de modal

### 📋 Características mantenidas

- ✅ Contadores (Procesados, Exitosos, Errores, Pendientes)
- ✅ Lista de items con imágenes y estados
- ✅ Actualización en tiempo real (WebSocket)
- ✅ Scroll infinito (limita a 20 exitosos, 50 errores)
- ✅ Persistencia en BD
- ✅ Multi-cuenta (aislado por account_id)
- ✅ Badge con contador de pendientes

### 🎨 UI/UX

**Tab "En Curso":**
- Aparece automáticamente cuando hay publicación activa
- Se oculta cuando no hay proceso (o tras 30s de finalizar)
- Badge muestra número de pendientes
- Click en tab → carga estado desde BD

**Contenido:**
- Contadores arriba (4 columnas)
- Lista scrollable de items
- Secciones: Procesando | Errores | Exitosos
- Aviso cuando hay items ocultos

### 🔄 Migración desde modal

**Código reutilizado de publishing-monitor.js:**
- `renderItem()` - Renderizar item individual
- `updateStats()` - Calcular contadores
- `loadStateFromDatabase()` - Cargar desde BD
- Lógica de limitación de items (Regla #38)

**Funcionalidad eliminada:**
- Minimizar/maximizar (ya no necesario)
- Overlay/backdrop (ya no necesario)
- Badge en footer (reemplazado por tab-badge)
- localStorage (100% BD)

### ⚙️ Configuración

No requiere configuración adicional. El tab aparece automáticamente cuando:
1. Usuario inicia publicación
2. Usuario hace login y hay publicación pendiente
3. Usuario cambia a cuenta con publicación activa

### 📊 Impacto

- **Código eliminado:** ~500 líneas
- **Código añadido:** ~400 líneas (más simple)
- **CSS:** Reutiliza variables existentes
- **Performance:** Mejor (render solo cuando activo)
- **Mantenibilidad:** Mucho mejor

---

## v6.11.13 - OPTIMIZACIÓN: Rendimiento Modal (2025-11-19)

### ⚡ Optimización crítica de rendimiento

**Problema:**
- Modal renderizaba TODOS los items (hasta 155) cada 250ms
- `container.innerHTML = renderItemsList()` recreaba TODO el DOM
- En equipos potentes se notaba lag al maximizar/minimizar
- Consumo excesivo de CPU y memoria

**Solución:**
- ✅ Limitar items mostrados:
  - **Exitosos**: Solo últimos 20 (más recientes)
  - **Errores**: Máximo 50 (primeros)
  - **Procesando**: Todos (normalmente 1)
- ✅ Aviso visual cuando hay items ocultos
  - "X anuncios publicados anteriormente"
  - "... y X errores más"
- ✅ Contadores totales siguen mostrando el número real

**Resultado:**
- Render de ~20 items en lugar de ~155 → **87% menos DOM**
- Modal fluida incluso con 100+ publicaciones
- Sin pérdida de información (contadores completos)

---

## v6.11.12 - Fix Modal no aparece al iniciar sesión (2025-11-19)

### 🐛 Bug: Modal no se restaura al hacer login con publicación pendiente

**Problema:**
- Al hacer login, los botones Reanudar/Cancelar SÍ aparecían
- Pero la modal de publicación en curso NO se restauraba
- `loadAccountState()` solo actualizaba botones, no llamaba a `initMonitor()`

**Solución:**
- ✅ `loadAccountState()` ahora llama a `initMonitor()` cuando hay pendientes
- ✅ `restoreFromDatabase()` usa SW en lugar de fetch directo (401 fix)
- ✅ Modal se restaura automáticamente al login si hay publicación en curso
- ✅ Cada cuenta de Wallapop tiene su propio estado de modal (ya funcionaba)

**Resultado:**
- Login con publicación pendiente → modal aparece automáticamente
- Cambio de cuenta → modal se muestra/oculta según corresponda
- Estado persiste por cuenta correctamente

---

## v6.11.11 - Fix Modal se queda al cerrar sesión (2025-11-19)

### 🐛 Bug: Modal de publicación visible tras logout

**Problema:**
- Al cerrar sesión, la modal de publicación en curso se quedaba minimizada en el footer
- Usuario sin sesión veía la modal (incorrecto)

**Solución:**
- ✅ Nueva función `forceClose()` en PublishingMonitor
- ✅ Llamada automática al recibir `SESSION.LOGGED_OUT`
- ✅ Oculta modal completamente
- ✅ Resetea estado interno
- ✅ Limpia storage

**Resultado:**
- Al cerrar sesión → modal desaparece inmediatamente
- Estado limpio para próximo login

---

## v6.11.10 - Fix 401 Unauthorized en monitor-state (2025-11-19)

### 🐛 Bug: 401 al cargar estado desde BD

**Problema:**
- `loadStateFromDatabase()` usaba `fetch()` directo con `localStorage.getItem('access_token')`
- Token podía estar vacío, expirado o null → 401 Unauthorized
- Monitor no cargaba estado de BD

**Solución:**
- ✅ Cambiar de `fetch()` directo a `chrome.runtime.sendMessage` con `API.FETCH_JSON`
- ✅ El SW maneja automáticamente tokens, refresh, y autenticación
- ✅ Mismo sistema que usa todo el resto del panel

**Resultado:**
- ✅ Siempre usa token válido (SW lo refresca si expira)
- ✅ Monitor carga correctamente estado de BD
- ✅ Contadores persisten tras reinicio

---

## v6.11.9 - FIX CRÍTICO: Contadores Exitosos/Errores en 0 (2025-11-19)

### 🐛 Bug CRÍTICO: Contadores se resetean a 0 tras reinicio

**Problema:**
- URL incorrecta en `publishing-monitor.js`: `https://mitiklive.com` (sin www ni /fa)
- Endpoint `/monitor-state` retornaba 404
- Monitor NO cargaba estado desde BD al iniciar
- Resultado: Exitosos=0, Errores=0 (aunque BD tenía los datos correctos)

**Solución:**
- ✅ Corregido `API_BASE_URL = 'https://www.mitiklive.com/fa'`
- ✅ Ahora `/monitor-state` funciona correctamente (200 OK)
- ✅ Monitor carga TODO el historial de BD al abrir panel
- ✅ Contadores persisten correctamente tras reinicio

**Resultado:**
- Procesados: ✅ Correcto (suma de exitosos + errores de BD)
- Exitosos: ✅ Correcto (lee de BD)
- Errores: ✅ Correcto (lee de BD)
- Pendientes: ✅ Correcto (calcula desde BD)

---

## v6.11.8 - Fix Botones Desaparecen (Debounce) (2025-11-18)

### 🐛 Bug: Botones Reanudar/Cancelar desaparecen durante polling

**Problema:**
- Durante refresh de token o polling automático, múltiples llamadas simultáneas a `promptPublishResumeIfPending()`
- Race condition: una llamada sobrescribe el estado de otra
- Resultado: botones desaparecen temporalmente, reaparecen en siguiente check

**Solución:**
- ✅ Añadido **flag de bloqueo** `isCheckingPending` para evitar ejecuciones simultáneas
- ✅ Añadido **debounce de 1 segundo** para ignorar llamadas muy frecuentes
- ✅ Liberación de flag en `finally` para garantizar desbloqueo

**Comportamiento ahora:**
- Si ya hay un check en curso → ignora llamada duplicada
- Si fue llamado hace menos de 1s → ignora (debounce)
- Solo ejecuta una vez por segundo máximo
- Evita race conditions y parpadeos de UI

---

## v6.11.7 - Debug Botones Desaparecen (2025-11-18)

### 🔍 Debug: Botones Reanudar/Cancelar desaparecen aleatoriamente

**Problema reportado:**
- Durante polling o refresh de tokens, los botones desaparecen
- Ocurre cuando backend devuelve `pending: 0` aunque haya pendientes

**Cambios de debug:**
- ✅ Añadidos logs detallados en `PUBLISH.PENDING` handler
- ✅ Log de account_id usado
- ✅ Log de respuesta completa del backend
- ✅ Log cuando pending=0 para identificar causa

**Objetivo:** Identificar por qué el backend devuelve `pending: 0` en algunos casos.

**Para usuario:** Revisar logs del Service Worker cuando los botones desaparezcan.

---

## v6.11.6 - Fix Reanudar (Navegar en lugar de Reload) (2025-11-18)

### 🐛 Bug: Reanudar mantenía formulario a medio rellenar

**Problema:**
- Click "Reanudar" hacía reload de la página actual
- Si estaba en otra página wallapop, recargaba ESA página
- Si el formulario estaba a medio rellenar, se mantenía sucio
- Resultaba en errores o datos incorrectos

**Solución:**
- ✅ Cambiar de `reload` a **navegar a `/upload`**
- ✅ Navegación garantiza formulario 100% limpio
- ✅ Solo 1 render/parpadeo (antes eran 2: navegar + reload)
- ✅ Más predecible: siempre empieza desde el mismo estado

**Flujo ahora:**
1. Click "Reanudar"
2. Navegar a `https://es.wallapop.com/app/catalog/upload`
3. Esperar carga completa
4. Continuar con siguiente item (formulario limpio garantizado)

---

## v6.11.5 - Fix Timing Radios de Peso (2025-11-18)

### 🐛 Bug: A veces no detecta radios de peso

**Problema:**
- Después de hacer click en "Estándar", esperaba solo 150ms fijos
- Los radios de peso se renderizan dinámicamente (AJAX/Angular)
- En PCs lentos o conexiones lentas, 150ms no era suficiente
- Resultado: "❌ Faltan campos: Peso del envío" aleatoriamente

**Solución:**
- ✅ Eliminado sleep fijo de 150ms
- ✅ Dejar que el `waitFor` siguiente espere activamente los radios
- ✅ Si aparecen rápido (100ms) → continúa inmediatamente
- ✅ Si son lentos (5s) → espera hasta timeout
- ✅ No desperdicia tiempo en PCs rápidos

---

## v6.11.4 - Fix Selectores Radiobuttons (2025-11-18)

### 🐛 Bug: Selectores incorrectos de radiobuttons

**Problema:**
- Buscaba radiobuttons por `value="standard"` y `value="bulky"` 
- Pero en el DOM real tienen:
  - Estándar: `name="delivery"`, `value="false"`
  - Voluminoso: `name="bulky"`, `value="true"`

**Solución:**
- ✅ Buscar por `name="delivery"` para Estándar
- ✅ Buscar por `name="bulky"` para Voluminoso
- ✅ Fallbacks por `aria-label` e `id`
- ✅ No rompe anuncios que funcionaban (los que no tienen dimensiones)

---

## v6.11.3 - Fix Scroll Radiobuttons (2025-11-18)

### 🐛 Bug: Radiobuttons no visibles en viewport

**Problema:**
- Radiobuttons "Estándar" y "Voluminoso" no se seleccionaban
- Causa: Estaban fuera del viewport (necesitaban scroll)

**Solución:**
- ✅ Añadido `scrollIntoView({ block: 'center' })` antes del click
- ✅ Espera de 300ms después del scroll para que se complete
- ✅ Aplicado tanto a "Estándar" como "Voluminoso"

---

## v6.11.2 - Fix Selección Radiobutton Estándar (2025-11-18)

### 🐛 Bug: No selecciona radiobutton Estándar/Voluminoso

**Problema:**
- Toggle de envío se activaba correctamente
- Pero NO seleccionaba el radiobutton "Estándar" o "Voluminoso"
- Quedaba sin selección, esperando radios de peso que no aparecen

**Causa:**
- La lógica esperaba directamente los radios de peso (tier_1, tier_2...)
- Pero Wallapop primero requiere seleccionar "Estándar" o "Voluminoso"
- Los radios de peso solo aparecen DESPUÉS de seleccionar "Estándar"

**Solución:**
- ✅ Añadido click en radiobutton "Estándar" ANTES de esperar radios de peso
- ✅ Misma lógica que ya existía para "Voluminoso"

**Archivos Modificados:**
- `scripts/publish/form-filler.js`: Añadida selección de radiobutton Estándar (líneas 2001-2024)

---

## v6.11.1 - Fix Lógica de Envío + Currency Timeout (2025-11-18)

### 🐛 Bug: Timeout de 15 segundos entre descripción y condición

**Problema:**
- Después de rellenar descripción, esperaba ~15 segundos antes de rellenar condición
- Causa: Currency intentaba `tryDD` con 4 métodos × 8s timeout cada uno aunque el campo no existiera
- Size ya tenía verificación rápida, pero currency no hacía early return

**Solución:**
- ✅ Añadida verificación rápida en currency: `if (!hidden) skip inmediato`
- ✅ Ahora todos los combos (brand, model, size, currency) tienen esperas inteligentes

### 🔧 Mejora Crítica: Nueva lógica de envío

**Problema Anterior:**
- Decidía voluminoso/estándar por flag `is_bulky` (a veces incorrecto)
- Rellenaba dimensiones DESPUÉS de activar toggle/radiobutton
- No verificaba estado actual del toggle (asumía)

**Nueva Lógica (Orden correcto):**
1. **Extraer dimensiones del JSON** (width, length, height)
2. **Si tiene las 3 dimensiones** → Rellenar ANTES del toggle
3. **Decidir tipo de envío por PRESENCIA de dimensiones:**
   - Tiene 3 dimensiones → VOLUMINOSO
   - Solo tiene peso → ESTÁNDAR
   - Sin dimensiones ni peso → SIN ENVÍO
4. **Verificar estado actual del toggle** y ajustarlo según corresponda
5. **Configurar radiobutton** según tipo (voluminoso/estándar)

**Casos Cubiertos:**
- ✅ Dimensiones → Toggle ON + dimensiones arriba + Voluminoso
- ✅ Solo peso → Toggle ON + Estándar + selección de peso
- ✅ Sin envío → Toggle OFF (desactivar si está activado)
- ✅ Con envío pero toggle OFF → Activar toggle + aplicar caso correspondiente

**Archivos Modificados:**
- `scripts/publish/form-filler.js`: Reescrita lógica de envío (líneas 1959-2135)

---

## v6.7.0 - Fix Reanudar + Marca/Modelo Robusto (2025-11-17)

### 🐛 Bug Crítico: Import Circular en SW

**Problema:**
```
boot.js → imports handleProcessNext from publish-process-next.js
publish-process-next.js → imports publishState from boot.js
→ Import circular → Service worker registration failed (code 15)
```

**Solución:**
- ✅ Nuevo archivo: `sw/state.js` con `publishState`
- ✅ Ambos archivos importan desde `state.js`
- ✅ 0 imports circulares

### 🐛 Bug Crítico: Doble Recarga en Publicación Nueva

**Problema Original:**
- Botón "Reanudar" encuentra pestaña existente → enfoca
- Formulario tiene datos a medio rellenar → bugs
- **Solución intentada:** SIEMPRE recargar si tab existe
- **Nuevo problema:** Doble recarga en publicación nueva ❌

**Flujo Problemático:**
```
Item 1: crea tab → navega /upload → OK
Item 2: tab existe → reload innecesario ❌
Item 3: tab existe → reload innecesario ❌
```

**Solución Final:**
- ✅ Agregar flag `is_resume` al mensaje `PUBLISH.START`
- ✅ Estado global `publishState` en SW
- ✅ Solo reload si `publishState.isResumeMode === true`

**Implementación:**

1. **panel.js:** Envía flag al iniciar
```javascript
PUBLISH.START → { is_resume: false }  // Publicación nueva
RESUME → { is_resume: true }          // Reanudar
```

2. **boot.js:** Guarda en estado global
```javascript
publishState = {
  isResumeMode: false,  // true solo en resume
  resetAt: timestamp
}
```

3. **publish-process-next.js:** Usa flag
```javascript
if (isOnUpload) {
  if (publishState.isResumeMode) {
    await chrome.tabs.reload(tab.id);  // ✅ Solo resume
  } else {
    // ✅ Publicación nueva, sin reload
  }
}
```

### 🐛 Bug: Combo Modelo Sin Opciones

**Problema:**
- Selecciona marca → llama `fillModelCombo()`
- Combo modelo AÚN NO tiene opciones (AJAX pendiente)
- Script intenta rellenar modelo vacío → falla

**Solución Anterior:**
```javascript
await sleep(1500);  // ❌ Tiempo fijo, puede fallar
```

**Solución Nueva:**
```javascript
// ✅ v6.7.0: Espera ACTIVA hasta que combo tenga opciones
while (Date.now() < maxWait) {
  const items = modelCombo.querySelectorAll('wallapop-combo-box-item');
  if (items.length > 0) break;  // Opciones listas ✅
  await sleep(300);
}
// Blur antes de rellenar (cierra listbox)
modelInput.blur();
await fillModelCombo(...);
```

**Estrategia:**
1. Hacer focus en combo modelo
2. Esperar hasta que `listbox` tenga `items.length > 0`
3. Blur (cerrar) antes de llamar `fillModelCombo()`
4. `fillModelCombo()` abre limpio con opciones ya cargadas

### 📦 Archivos Modificados
- `panel.js`: Envía flag `is_resume` (línea ~251)
- `sw/boot.js`: Estado global `publishState` + save/reset
- `sw/handlers/publish-process-next.js`: Import + uso de flag
- `scripts/publish/form-filler.js`: Espera activa de opciones modelo
- `manifest.json`: Versión 6.7.0

### ✅ Casos Cubiertos

**Reanudar:**
- Tab nueva → crear + navegar
- Tab existe, fuera de /upload → navegar
- Tab existe, en /upload + **resume mode** → reload ✅
- Tab existe, en /upload + **publicación nueva** → sin reload ✅

**Marca/Modelo:**
- AJAX rápido → funciona
- AJAX lento → espera activa hasta 8s
- Sin opciones → error claro con timeout

---

## v6.6.9 - Monitor Persistente + Sync con BD (2025-11-17)

### 🔄 Sincronización con Base de Datos

**Problema:** 
- Monitor solo en memoria → Refrescar panel = pérdida de contadores
- Backend cuenta `error_retry` pero monitor contaba `error`
- Estados desincronizados entre BD y UI

**Solución:**

**1. Unificación de Estados:**
- ✅ SW envía `status: 'error_retry'` (antes: `'error'`)
- ✅ Monitor cuenta `error_retry` (sync con BD)
- ✅ Backend ya usa `error_retry` correctamente

**2. Carga Inicial desde BD:**
- ✅ `startMonitor()` ahora es `async`
- ✅ Consulta `/api/publish2/status` para contadores
- ✅ Consulta `/api/publish2/list` para items
- ✅ Convierte `publish_status` BD → `status` monitor:
  - `published` → `success`
  - `error_retry` → `error_retry`
  - `processing` → `processing`

**3. Actualización Dual:**
```
Panel carga
    ↓
startMonitor() → Carga BD (estado inicial)
    ↓
Muestra contadores correctos (persistente)
    ↓
Durante publicación: SW envía PUBLISH_ITEM_UPDATE
    ↓
Monitor actualiza en tiempo real
    ↓
Siempre sincronizado con BD
```

### 📦 Archivos Modificados
- `sw/handlers/publish-process-next.js`: 3 cambios `error` → `error_retry`
- `scripts/panel/publishing-monitor.js`: 
  - `startMonitor()` async con carga BD
  - 5 cambios `status === 'error'` → `status === 'error_retry'`
  - API_BASE_URL constante
- `panel.js`: `await startMonitor()` 
- `manifest.json`: Versión 6.6.9

### ✅ Beneficios
- Refrescar panel NO pierde contadores
- Estados 100% sincronizados BD ↔️ UI
- Contador errores muestra datos reales de BD
- Persistencia completa

---

## v6.6.8 - Fix Selección de Peso (Radio Buttons) (2025-11-17)

### 🐛 Corrección de Bug Crítico
- **Radio de peso no se marca**: Click ejecutado pero radio queda "bordeado" sin marcar
  - Causa: Después de activar toggle de envío, los radios se renderizan pero no son interactivos inmediatamente
  - Script intentaba click antes de que fueran interactivos
  - Resultado: Radio con borde focus pero `checked=false`

### 🔧 Mejoras Técnicas

**`dom.js` - `selectWeightTier()` reforzada:**
- ✅ Verifica `disabled` y `offsetParent` antes de hacer click
- ✅ Scroll al elemento para asegurar visibilidad
- ✅ Reintentos hasta 3 veces con `dispatchPointerClick()`
- ✅ Fallback a `.click()` nativo si falla
- ✅ Fallback a click en `<label>` si persiste
- ✅ Logs detallados de cada intento
- ✅ Espera 300ms entre verificaciones

**`form-filler.js` - Espera mejorada de radios:**
- ✅ No solo espera que existan (`length >= 6`)
- ✅ Verifica que sean interactivos (`!disabled && offsetParent !== null`)
- ✅ Delay adicional 280-520ms antes de seleccionar
- ✅ Logs: "Radios presentes pero no interactivos, esperando..."

### 📊 Estrategia de Reintentos

```javascript
Intento 1: dispatchPointerClick() + verificar (300ms)
    ↓ Falló
Intento 2: dispatchPointerClick() + verificar (300ms)
    ↓ Falló
Intento 3: dispatchPointerClick() + verificar (300ms)
    ↓ Falló
Fallback 1: radio.click() nativo + verificar (400ms)
    ↓ Falló
Fallback 2: label.click() + verificar (400ms)
    ↓ Si falla todo → Error detallado
```

### 📦 Archivos Modificados
- `scripts/dom.js`: `selectWeightTier()` (~60 líneas reescritas)
- `scripts/publish/form-filler.js`: Espera de radios interactivos (~15 líneas)
- `manifest.json`: Versión 6.6.8

---

## v6.6.7 - Navegación Robusta (Todos los Edge Cases) (2025-11-17)

### 🎯 Mejoras Críticas - Cubre TODOS los Edge Cases

#### Edge Case 1: Race Condition con Navegación de Wallapop ✅
**Problema:** Wallapop puede estar navegando a "Tus productos" mientras verificamos
**Solución:** 
- Esperar 1.5s para que Wallapop complete su navegación interna
- Re-verificar URL después de esperar
- Si cambió → navegar forzosamente

#### Edge Case 2: Tab Cerrado ✅
**Problema:** Usuario cierra tab durante operación
**Solución:**
- Verificar `chrome.tabs.get(tab.id)` antes de cualquier operación
- Error claro: "La pestaña de Wallapop se cerró"

#### Edge Case 3: CS Muerto pero URL Correcta ✅
**Problema:** CHECK_FORM_DIRTY falla → asume dirty → recarga innecesaria
**Solución:**
- Verificar CS con `ensureCS()` ANTES de CHECK_FORM_DIRTY
- Si CS muerto → reintentar reinyección
- Solo recargar si realmente hay datos o CS irrecuperable

#### Edge Case 4: Modal Bloqueante ✅
**Problema:** Modal "¡Yuhu!" bloquea CHECK_FORM_DIRTY
**Solución:**
- Esperar 1.5s para que modal se cierre naturalmente
- Si CHECK_FORM_DIRTY falla por timeout → considerar modal presente
- Acción: refrescar para limpiar

#### Edge Case 5: Formulario Limpio pero Modal Visible ✅
**Problema:** URL correcta + formulario limpio pero modal aún presente
**Solución:**
- No navegar si formulario está limpio
- WAIT_UPLOAD_READY verificará modales después
- Ahorra navegación innecesaria

### 🔧 Lógica Mejorada

```javascript
if (URL es /upload) {
  ⏳ Esperar 1.5s (Wallapop completa navegación)
  
  if (URL cambió a otra página) {
    → NAVEGAR forzosamente a /upload
  } else {
    → Verificar CS vivo
    → Reintentar reinyección si muerto
    → CHECK_FORM_DIRTY (solo si CS vivo)
    
    if (formulario sucio O CS irrecuperable) {
      → RELOAD
    } else {
      → ✅ Listo, continuar
    }
  }
} else {
  → NAVEGAR directamente a /upload
}
```

### 📊 Ventajas
- ✅ Maneja tab cerrado
- ✅ Maneja race condition con Wallapop
- ✅ Reinicia CS si está muerto
- ✅ No recarga innecesariamente
- ✅ Espera a que Wallapop complete su flujo
- ✅ Logs detallados de cada decisión

### 📦 Archivos Modificados
- `sw/handlers/publish-process-next.js`: Lógica de navegación completamente reescrita (~140 líneas)
- `manifest.json`: Versión 6.6.7

---

## v6.6.6 - Navegación Activa a /upload (2025-11-17)

### 🎯 Solución Definitiva al Problema
- **Navegación ACTIVA en lugar de pasiva**: El script ahora navega explícitamente a `/upload` al inicio de cada item
  - Problema identificado: Después de publicar, Wallapop muestra modal "¡Yuhu!" pero NO siempre navega a `/upload`
  - A veces se queda en el modal, otras navega a "Tus productos" 
  - El script asumía que Wallapop navegaría solo → **ERROR**
  - Solución: **Navegar ACTIVAMENTE** usando `chrome.tabs.update()` al inicio de cada item

### 🔧 Cambios Implementados
- **Navegación forzada al inicio de `PROCESS_NEXT`**:
  - Ya NO confiamos en que Wallapop navegue después del modal
  - SIEMPRE navegamos explícitamente: `chrome.tabs.update(tab.id, { url: '/upload' })`
  - Esto cierra cualquier modal y asegura URL correcta
  - Espera `status='complete'` antes de continuar

- **Lógica mejorada**:
  ```
  Si ya en /upload:
    → Verificar formulario sucio
    → Si sucio: RELOAD
    → Si limpio: NAVEGAR (cierra modales)
  Si no en /upload:
    → NAVEGAR directamente
  ```

### 📊 Por qué funciona
- ✅ Cierra el modal "¡Yuhu!" si está presente
- ✅ Sale de "Tus productos" si navegó ahí
- ✅ Asegura URL correcta antes de cualquier verificación
- ✅ Combinado con `WAIT_UPLOAD_READY`, garantiza página lista
- ✅ NO depende del comportamiento impredecible de Wallapop

### 🐛 Bugs Resueltos
- ❌ "Timeout esperando página de upload" → Ahora navega activamente
- ❌ Se quedaba en modal "¡Yuhu!" → Navegación lo cierra
- ❌ Navegaba a "Tus productos" → Navegación lo corrige
- ❌ Error intermitente cada 3-4 anuncios → Ahora consistente

### 📦 Archivos Modificados
- `sw/handlers/publish-process-next.js`: 
  - Lógica de navegación completamente reescrita (~70 líneas)
  - SIEMPRE navega o recarga, no asume estado correcto
  - Logs detallados de cada paso
- `manifest.json`: Versión 6.6.6

---

## v6.6.5 - Aumentar Timeouts y Mejorar Logs (2025-11-17)

### 🔧 Corrección de Timeouts
- **Timeout aumentado de 15s → 25s**: El timeout de `WAIT_UPLOAD_READY` era insuficiente
  - Content script: 15s → 25s para verificaciones internas
  - Service worker: 15s → 30s para llamada al CS (con margen de 5s)
  - Causa: En conexiones lentas o con muchos anuncios, Wallapop tarda más en navegar y cargar

### 📊 Mejoras de Logging
- **Logs progresivos durante esperas**:
  - Log cada 5 checks (~1.25s) mostrando estado de modales
  - Log cada 5 checks (~1s) mostrando estado del contenedor
  - Incluye tiempo transcurrido en cada log
  - Ayuda a identificar dónde se queda atascado si hay timeout

- **Errores más descriptivos**:
  - Incluye `elapsed_ms` en respuestas de error
  - Incluye `current_url` y estado de elementos encontrados
  - Permite debugging más preciso

### 🐛 Corrección Adicional
- **Delay de 500ms después de desaparecer modal**: Da margen extra para que Wallapop termine de renderizar

### 📦 Archivos Modificados
- `content_script.js`: 
  - Timeout 15s → 25s
  - Logs progresivos cada 5 checks
  - Delay de 500ms post-modal
- `sw/handlers/publish-process-next.js`: 
  - Timeout 15s → 30s
  - Log con elapsed_ms
- `manifest.json`: Versión 6.6.5

---

## v6.6.4 - Verificación Inteligente Pre-Vertical (2025-11-17)

### 🎯 Solución Inteligente (SIN delays fijos)
- **Nuevo handler `PUBLISH.WAIT_UPLOAD_READY`**: Verificación activa e inteligente del estado de la página
  - Verifica URL correcta (`/app/catalog/upload`)
  - Espera a que desaparezcan modales de Wallapop (modal "¡Yuhu! Producto subido")
  - Confirma que el contenedor de vertical esté presente Y visible
  - Verifica que los botones de categoría estén renderizados
  - Timeout inteligente de 15s con polling cada 200-250ms

### 🐛 Corrección de Bug Intermitente
- **Error "Sin respuesta" intermitente eliminado**: Ya no ocurre el error cada 3-4 anuncios
  - Problema identificado: El SW asumía que estar en `/upload` URL era suficiente, pero no verificaba que el DOM estuviera listo
  - Después de publicar exitosamente, Wallapop muestra modal y navega, pero los elementos no están listos inmediatamente
  - Solución: Handler de verificación que espera activamente a que TODO esté listo antes de intentar seleccionar vertical

### 🔧 Mejoras Técnicas
- **Flujo mejorado en `publish-process-next.js`**:
  1. Navega/recarga → espera `status='complete'`
  2. Verifica CS responde (ping)
  3. **NUEVO:** Llama `WAIT_UPLOAD_READY` para confirmar página lista
  4. Solo entonces llama `SELECT_VERTICAL`
  
- **Handler `WAIT_UPLOAD_READY` en `content_script.js`**:
  - Espera activa con checks cada 200-250ms
  - Verifica 4 condiciones críticas
  - Retorna `{ok: true, buttons_found: N, elapsed_ms: X}`
  - Timeout de 15s con error detallado si falla
  
- **`selectVerticalForUpload()` simplificado**:
  - Eliminadas verificaciones redundantes (ya las hace WAIT_UPLOAD_READY)
  - Solo verifica URL mínima y obtiene elemento directamente
  - Código más limpio y mantenible

### 📊 Ventajas vs Delays Fijos
- ✅ No desperdicia tiempo esperando innecesariamente
- ✅ Se adapta a velocidades de carga variables
- ✅ Falla rápido con error claro si hay problema real
- ✅ Logs detallados para debugging
- ✅ Más robusto ante cambios en Wallapop

### 📦 Archivos Modificados
- `content_script.js`: Nuevo handler `PUBLISH.WAIT_UPLOAD_READY` (~90 líneas)
- `sw/handlers/publish-process-next.js`: Añadida llamada a `WAIT_UPLOAD_READY` antes de `SELECT_VERTICAL`
- `scripts/publish.js`: 
  - `selectVerticalForUpload()` simplificado
  - `waitStepVertical()` simplificado (ya no hace verificaciones complejas)
- `manifest.json`: Versión 6.6.4

---

## v6.6.3 - Fix Error "Sin respuesta" en Selección de Vertical (2025-11-17)

### 🐛 Corrección de Bug Crítico
- **Error "Sin respuesta" después de publicar**: El script intentaba seleccionar la vertical antes de que la página estuviera completamente cargada
  - Causa: Después de publicar un anuncio, Wallapop muestra un modal de confirmación y navega de vuelta a `/app/catalog/upload`, pero el script no esperaba a que la página estuviera lista
  - Síntoma: "❌ Error seleccionando vertical: Sin respuesta" justo después de publicar exitosamente
  - Solución: Espera robusta que verifica:
    1. URL correcta `/app/catalog/upload`
    2. Ausencia de modales bloqueantes
    3. Presencia y visibilidad del contenedor de vertical
    4. Delay adicional para asegurar que todos los botones estén renderizados

### 🔧 Mejoras Técnicas
- **`waitStepVertical()` mejorada**: 
  - Verifica que estamos en la URL correcta antes de buscar el elemento
  - Valida que el elemento esté visible (`offsetParent !== null`)
  - Retorna `null` si no cumple todas las condiciones
  
- **`selectVerticalForUpload()` reforzada**:
  - Espera activa hasta 10s para confirmar URL correcta
  - Espera hasta 8s para que desaparezcan modales/overlays
  - Usa `waitStepVertical()` mejorada (hasta 18s)
  - Delay humano adicional de 560-1040ms antes de hacer clic
  - Logs detallados en cada paso para debugging

### 📦 Archivos Modificados
- `scripts/publish.js`: 
  - Función `waitStepVertical()` (líneas ~131-156)
  - Función `selectVerticalForUpload()` (líneas ~307-418)
- `manifest.json`: Versión 6.6.3

---

## v6.6.2 - Mejoras de Logging para Depuración (2025-11-17)

### 🔧 Mejoras de Depuración
- **Logging mejorado en marcar processing**: Captura detallada del payload enviado y respuesta de error
  - Muestra status HTTP, statusText y body de error completo
  - Ayuda a identificar problemas de serialización o comunicación

### 📦 Archivos Modificados
- `sw/handlers/publish-process-next.js`: Logging mejorado en actualización de estado

---

## v6.6.1 - Fix Bug [object Object] en Títulos (2025-11-17)

### 🐛 Corrección de Bug Crítico
- **Títulos mostraban `[object Object]`**: Los títulos de anuncios se mostraban como `[object Object]` en lugar del texto real
  - Causa: El campo `title` en `json_data` es un objeto `{original: "texto"}` y la lógica de fallback pasaba el objeto completo cuando `original` estaba vacío
  - Solución: Nueva función `extractTitle()` centralizada en `sw/utils.js` que maneja correctamente la estructura

### 🔧 Mejoras Técnicas
- **Nueva función centralizada `extractTitle()`**: 
  - Ubicación: `sw/utils.js`
  - Maneja tanto objetos `{original: "texto"}` como strings directos
  - Valida que el resultado sea string no vacío antes de usarlo
  - Fallback configurable (default: 'Sin título')

- **Correcciones en `sw/handlers/publish-process-next.js`**:
  - 15+ lugares corregidos donde se extraía el título incorrectamente
  - Imports actualizados para usar la función centralizada
  - Consistencia en logs y contextos de error

### 📦 Archivos Modificados
- `sw/utils.js`: Nueva función `extractTitle()`
- `sw/handlers/publish-process-next.js`: 15+ correcciones de extracción de título
- `manifest.json`: Versión 6.6.1

---

## v6.6.0 - Monitor de Publicación en Tiempo Real (2025-11-17)

### ✨ Nueva Funcionalidad
- **Modal de Monitor de Publicación**: Vista en tiempo real de todos los anuncios durante la publicación
  - Muestra TODOS los anuncios con scroll (procesando, exitosos, errores)
  - Estadísticas en vivo: procesados, exitosos, errores, pendientes
  - Barra de progreso con porcentaje y animación shimmer
  - Imágenes miniatura, título y precio de cada anuncio
  - Errores detallados con mensaje específico (ej: "Campo requerido 'condition' no se pudo rellenar")
  - Animaciones suaves de entrada/salida para items

- **Badge Minimizable en Footer**: La modal se puede minimizar al footer
  - Click para minimizar con efecto de transición
  - Badge con pulso suave mostrando progreso (ej: "45/111")
  - Badge cambia a naranja si hay errores
  - Click en badge para maximizar de nuevo

- **Integración Service Worker**: El SW envía datos completos al panel
  - Nuevo mensaje `PUBLISH_ITEM_UPDATE` con id, título, precio, imagen, status, error
  - Se envía al iniciar procesamiento (status: 'processing')
  - Se envía al completar (status: 'success')
  - Se envía al fallar (status: 'error' + detalle)

### 🗑️ Eliminado
- Filtro "Publicando" de la barra de estadísticas (reemplazado por el monitor)

### 🎨 Estilos
- Nuevo archivo `styles/publishing-monitor.css` con diseño moderno
  - Overlay con blur y animación fadeIn
  - Modal con gradientes y sombras elegantes
  - Items con bordes coloreados según estado
  - Scrollbar personalizada
  - Responsive para pantallas pequeñas

### 🔧 Archivos Modificados
- `panel.html`: Badge en footer, CSS importado
- `panel.js`: Import y listeners para PublishingMonitor
- `scripts/panel/publishing-monitor.js`: Módulo completo del monitor
- `sw/handlers/publish-process-next.js`: Envío de datos al panel
- `styles/publishing-monitor.css`: Estilos visuales
# 📝 CHANGELOG - MitikLive Wallapop Helper

## [v6.5.3] - 2025-11-16

### 🎯 TEMA: Centralización, Modularización y Manejo de Errores Inteligente

Esta versión introduce arquitectura más robusta con constantes centralizadas, manejo de errores con reintentos inteligentes, y mejoras en el Service Worker.

---

### ✨ NUEVAS CARACTERÍSTICAS

#### 1. Sistema de Constantes Centralizadas
- **scripts/publish/constants.js** (9KB)
  - 18 constantes de TIMEOUTS documentadas
  - 14 constantes de DELAYS para comportamiento humano
  - 20+ SELECTORS CSS reutilizables
  - Configuración de RETRY (intentos, backoff)
  - Códigos de error estándar

- **sw/constants.js** (8KB) - 🆕 NUEVO
  - SW_TIMEOUTS para comunicación SW↔CS
  - SW_DELAYS entre operaciones
  - SW_RETRY configuración de reintentos
  - CS_MESSAGES tipos de mensajes
  - Funciones utilitarias (calculateBackoffDelay, humanDelay)

#### 2. Sistema de Manejo de Errores con Reintentos
- **scripts/publish/error-handler.js** (15KB) - 🆕 NUEVO
  - Clasificación automática de errores (TRANSIENT, PERSISTENT, FATAL)
  - `retryWithBackoff()` - Reintentos con backoff exponencial
  - `CircuitBreaker` - Evita cascadas de fallos
  - `RECOVERY_STRATEGIES` - Estrategias de recuperación por tipo
  - `createStructuredError()` - Errores estructurados para logging

#### 3. Retry Inteligente en form-filler.js
- Nueva función `tryDDWithRetry()` para dropdowns
- Backoff exponencial entre intentos (1s → 1.5s → 2.25s)
- Jitter ±20% para anti-detección
- Clasificación automática de errores
- Recovery personalizable por campo

### 🔧 MEJORAS TÉCNICAS

#### Migración de Timeouts
- **publish.js**: 22 usos de TIMEOUTS.* + 6 usos de DELAYS.*
- **form-filler.js**: 14 usos de TIMEOUTS.* + 6 usos de DELAYS.*
- **publish-process-next.js**: 14 usos de SW_TIMEOUTS.* + SW_DELAYS.*
- **Total**: 62 constantes centralizadas

#### Service Worker Mejorado
- Timeouts específicos por tipo de mensaje (CS_MESSAGES)
- Delays configurables entre pasos
- Comunicación más robusta SW↔CS
- Mejor manejo de timeouts en credenciales

#### Modularización
- fillListingForm() en módulo separado (1733 líneas)
- Error handling como módulo independiente
- publish.js reducido de 3371 a 1720 líneas (-49%)
- Re-export mantiene compatibilidad total

### 📊 MÉTRICAS

| Componente | Antes (v6.5.2) | Después (v6.5.3) | Mejora |
|------------|----------------|-------------------|--------|
| publish.js | 3371 líneas | 1720 líneas | -49% |
| Archivos modulares | 1 | 4 | +3 |
| Timeouts hardcodeados | 60+ | 2 | -97% |
| Constantes centralizadas | 0 | 62 | ✅ |
| Sistema de retry | Básico | Exponencial + Recovery | ✅ |
| Circuit breaker | ❌ | ✅ | 🆕 |

### 🔄 COMPATIBILIDAD

- ✅ **100% retrocompatible** con v6.5.2
- ✅ Todas las APIs públicas mantienen misma firma
- ✅ Mensajes SW ↔ CS sin cambios
- ✅ Backend no requiere actualización

### 📁 ARCHIVOS MODIFICADOS/NUEVOS

```
scripts/
├── publish.js                    # ✅ Migrado a constantes
└── publish/
    ├── constants.js              # ✅ Constantes centralizadas
    ├── form-filler.js            # ✅ + Retry inteligente
    └── error-handler.js          # 🆕 Manejo de errores

sw/
├── constants.js                  # 🆕 Constantes del SW
└── handlers/
    └── publish-process-next.js   # ✅ Migrado a constantes

manifest.json                     # ✅ Versión 6.5.3
CHANGELOG.md                      # ✅ Actualizado
```

### 🧪 TESTING RECOMENDADO

1. **Publicación básica** - Verificar constantes funcionan
2. **Publicación con errores** - Verificar reintentos
3. **Dropdown difícil** - Verificar retry inteligente
4. **Red inestable** - Verificar circuit breaker
5. **Logs** - Verificar errores estructurados

### 📝 NOTAS DE INSTALACIÓN

1. Reemplazar carpeta `extension/` completa
2. Verificar imports de constants.js en todos los módulos
3. Los valores de timeouts son IDÉNTICOS, solo centralizados
4. El nuevo error-handler.js es opcional pero recomendado

---

## [v6.5.2] - 2025-11-15
- Versión anterior con funcionalidad completa

---

**Mantenido por:** Javier  
**Asistido por:** Claude AI  
**Guía seguida:** GUIA-REUTILIZACION-CODIGO-v3_1.md
